#include "coordinate.h"
#include "mbed.h"
#include "pinnames.h"
#include "debug.h"
#include "workinfo.h"
#include "math.h"
#include "servo.h"
//////////////////////////////変更できるパラメータ
const double kArmLength[4]= {316, 321, 105, 259};//316, 316, ,259.85
const double kArmOrigin[3] = {-199, -80, 125};//アームの根本の座標//-194.13,-75,
//////////////////////////////
const double kRadToDegree = 180/3.14159265359;
const double kDegreeToRad = 3.14159265359/180;
//アーム最大値の2乗
const int kMaxLength2 = (kArmLength[0] + kArmLength[1]) * (kArmLength[0] + kArmLength[1]);

Enc1Multi ec(pin_encoder[0][0], pin_encoder[0][1], 500);
//現在のサーボ角度（相対角）
double now_rad_relative[SERVONUM - 1] = {};
//次に動かすサーボ角度（相対角）
double next_rad_relative[SERVONUM - 1] = {};

double nowz=0;

void EcSetup()
{
    DEBUG("EcSetup() start\r\n");
    ec.SetDiameter_mm(35);//データシートor実測した値
    ec.SetGearRate(-1);
    DEBUG("EcSetup() finish\r\n");
}
double GetNowTipLocateX()
{
    double x = 0;
    for(int i = 0; i < 3; i++) x += kArmLength[i] * cos(GetNowRad(i));//i番目のlinkのx成分
    x += kArmLength[3] * cos(GetNowRad(3)) * cos(GetNowRad(2));//4番目のlink. z方向に傾いている
    return x + kArmOrigin[0];
}
double GetNowTipLocateY()
{
    double y = 0;
    for(int i = 0; i < 3; i++) y += kArmLength[i] * sin(GetNowRad(i));//i番目のlinkのx成分
    y += kArmLength[3] * cos(GetNowRad(3)) * sin(GetNowRad(2));//4番目のlink. z方向に傾いている
    return y + kArmOrigin[1];
}
double GetNowTipLocateZ()
{
    return GetNowElbowZ() + kArmLength[3] * sin(GetNowRadRelative(3));
}
double GetNowElbowX()
{
    double x = 0;
    for(int i = 0; i < 3; i++) x += kArmLength[i] * cos(GetNowRad(i));//i番目のlinkのx成分
    return x + kArmOrigin[0];
}
double GetNowElbowY()
{
    double y = 0;
    for(int i = 0; i < 3; i++) y += kArmLength[i] * sin(GetNowRad(i));//i番目のlinkのx成分
    return y + kArmOrigin[1];
}
double GetNowElbowZ()
{
    #ifdef NOTZMOVE
    return nowz;
    #else 
    return ec.GetDistance_mm() + kArmOrigin[2];
    #endif
    
}
double GetNowRad(int num)
{
    double rad = 0;
    if(num == 3) rad = GetNowRadRelative(num);
    else for(int i = 0; i <= num; i++)rad += GetNowRadRelative(i);
    return rad;
}
void SetNowRadRelative(int num, double rad)
{
    now_rad_relative[num] = rad;
}
double GetNowRadRelative(int num)
{
    return now_rad_relative[num];
}
void SetNextRadRelative(int num, double rad)
{
    next_rad_relative[num] = rad;
}
double GetNextRadRelative(int num)
{
    return next_rad_relative[num];
}
//2link 逆運動学
//theta2 = arccos((x^2 + y^2 - L1^2 - L2^2)/(2*L1*L2))
//theta1 = arctan(y/x) - arccos((cos(theta2) * L2 + L1)/sqrt(x^2+^2))
const double kL1L1L2L2 = kArmLength[0] * kArmLength[0] + kArmLength[1] * kArmLength[1];
const double kReverse2L1L2 = 1 /(2 * kArmLength[0] * kArmLength[1]);
void Set2LinkRad(double x_relative, double y_relative)
{
    double x2y2 = x_relative*x_relative + y_relative*y_relative;
    if(x2y2 > kMaxLength2 || x2y2 == 0) return;
    double temp1 = (x2y2 - kL1L1L2L2) * kReverse2L1L2;
    SetNextRadRelative(1, acos(temp1));
    double temp0 =  (temp1 * kArmLength[1] + kArmLength[0])/sqrt(x2y2);
    SetNextRadRelative(0, atan2(y_relative, x_relative) - acos(temp0));
}
//serov0,1の値を使って計算するので、決まってから呼び出す
void SetServoYawRad(double yaw_rad)
{
    double rad = yaw_rad - GetNextRadRelative(0) - GetNextRadRelative(1);
    SetNextRadRelative(2,rad);
}
void SetServoPitchRad(double pitch_rad)
{
    SetNextRadRelative(3, pitch_rad);
}
double GetFromElbowToHand(unsigned int axis, double yaw_rad, double pitch_rad)
{
    double result = 0;
    switch(axis) {
        case X:
            result = kArmLength[3] * cos(pitch_rad) * cos(yaw_rad);
            break;
        case Y:
            result = kArmLength[3] * cos(pitch_rad) * sin(yaw_rad);
            break;
        case Z:
            result = kArmLength[3] * sin(pitch_rad);
            break;
    }
    return result;
}