/** @file
*@brief ワークの状態をまとめたファイル
*/
#ifndef INCLUDED_STATE_STATE_H
#define INCLUDED_STATE_STATE_H
//全ファイルで共通して使うdefine
#define RIGHT
//#define NOTZMOVE
//#define USEDISCOVERYBOARD

///@brief ワークの色。ボックスでは置いてあるワークの色を示す。
enum Color {
    YELLOW,
    RED,
    NOCOLOR,
};
///@brief 場所名
enum AreaName {
    WORKAREA,
    COMMONAREA,
    BOX,
};
enum ArmState {
    HORIZON,
    VERTICAL,
    FOLD,
};
enum Axis {
    X,Y,Z
};
enum Pattern {A, B, C, D,
              NOPATTERN,//まだ決まっていなければNOPATTERN
             };
enum HandState {
    OPEN,
    CLOSE,
};
class LocateParam
{
public:
    LocateParam();
    LocateParam(double x, double y, double z,
                double elbow_x, double elbow_y, double elbow_z,
                double yaw, double pitch);
    double position[3];
    double elbow[3];
    double yaw_rad;//理想のアームyaw
    double pitch_rad;
};
class WorkState: public LocateParam
{
public :
    WorkState();
    AreaName areaname;
    Color color;
    HandState hand;
    int priority;
    int is_exist; //ゲーム開始時にワークがおいてあるかどうか.あったら１
};

class WorkPosi : public WorkState
{
};
class BoxPosi : public WorkState
{
public :
    BoxPosi();
};

#endif