#ifndef INCLUDED_HAND_H
#define INCLUDED_HAND_H
#include "state.h"
/** @file
@brief シリアルサーボの駆動及び実機体への調整
*/
#define SERVONUM 5//ハンド先以外のサーボの個数
extern double OriginDegree[SERVONUM - 1];
extern const double kOriginDegree[SERVONUM - 1];
extern const int kServoSpan_ms; //指示の前後に必要なwait
///@brief 指定idのサーボをrad_relativeの角度にする.現在角度も更新
void ServoRad(int id, double rad_relative);
///@brief ハンド先以外の全てのサーボを動かす
void ServoMoveOnArm();
///@brief サーボを一つ動かす。動かすサーボは関数を呼ぶ毎に順々に変わる。ハンド先を動かすことはない
void ServoMoveOnArmInTurns();
///@breif ハンドを開く
void Open();
///@brief ハンドを閉じる
void Close();
#endif