#ifndef INCLUDED_GO_H
#define INCLUDED_GO_H
/** @file
@brief 目標位置まで行くプログラム.
*/
#include "state.h"
#include "calPID.h"
#include "motorout.h"
extern const double kPIDTicker_s;
extern const double kCalTargetTicker_s ;
extern const double kServoMoveTicker_s;
extern int cal_target_ticket;
extern int motor_move_ticket;
extern int servo_move_ticket;

extern const double kServoVelocity_mm;
extern double servo_dist_mm;
extern double output;
extern CalPID calpid;
extern MotorOut motor;
///@brief プログラム初期設定
void GoSetup();
//tickerで呼ぶ
inline void PIDInterrupt()
{
    motor_move_ticket = 1;
};
inline void CalTargetInterrupt()
{
    cal_target_ticket = 1;
};
inline void ServoMoveInterrupt(){
    servo_move_ticket = 1;
}

int Go(WorkState workstate);
//少し上昇
void Above(AreaName areaname);
//ゆっくり0点に戻るときに使う
void GoToZeroSlowly();
//初期値に移動
void GoToFirstPosition();
//行ける目標値、yaw,pitchからsafe.elbowを計算.特例としてelbowはサーボ2の位置とする。elbowそのものを示していないので注意
void AllTargetToElbow(LocateParam &safe);
//サーボ出力値計算
void CalServoMove(LocateParam safe, LocateParam now);
//motor出力値。リミット機構搭載
double GetMotorOutPutZ();
///@brief 確実にワークに入れるため少し動かす
void MoveToPut(LocateParam target);
#endif