#include "filesystem.h"
#include "mbed.h"
#include "workinfo.h"
#include "debug.h"

LocalFileSystem local("local");
const char kFileName[100] = "/local/workdata.txt";
const char kComment[][100] = {"pattern", "work_not_exist","box_exist_and_color"};
void FileSave()
{
    FILE *fp;
    DEBUG("FileSave() start\r\n");
    if((fp = fopen(kFileName, "w")) == NULL) {
        DEBUG("error : FileSave()\r\n");
        return;
    }
    fprintf(fp, "%s\r\n", kComment[0]);
    fprintf(fp, "%d\r\n", now_pattern);
    fprintf(fp, "%s\r\n", kComment[1]);
    for(int i = 0; i < kWorkAreaNum + kCommonAreaNum; i++) {
        if(work[i].is_exist == 0) fprintf(fp, "%d\r\n", i);
    }
    fprintf(fp, "%s\r\n", kComment[2]);
    for(int i = 0; i < kBoxNum; i++) {
        if(shootingbox[i].is_exist == 1) fprintf(fp, "%d\r\n%d\r\n", i, shootingbox[i].color);
    }
    fclose(fp);
    DEBUG("FileSave() finish\r\n");

}
void FileLoad()
{
    DEBUG("FileLoad() start\r\n");
    FILE *fp;
    if((fp = fopen(kFileName, "r")) == NULL) {
        DEBUG("There is no file\r\n");
        return;
    }
    int old_num = 0;
    int comment_num = 0;
    while(1) {
        char comment[100] = {};
        char *error;
        if(fscanf(fp,"%s",comment) == -1) {
            DEBUG("FileLoad() finish\r\n");
            fclose(fp);
            return;
        }
        int num = strtod(comment, &error);
        if (*error != '\0') {
            DEBUG("%s\r\n",error);
            for(int i = 0; i < sizeof(kComment)/sizeof(kComment[0]); i++) {
                if(strcmp(comment, kComment[i]) == 0) comment_num = i;
            }
        } else {
            switch(comment_num) {
                case 0:
                    DEBUG("pattern is %d\r\n",num);
                    now_pattern = (Pattern)num;
                    break;
                case 1:
                    DEBUG("work %d is not exist\r\n",num);
                    work[num].is_exist = 0;
                    break;
                case 2:
                    static int is_boxnum = 0;
                    is_boxnum = !is_boxnum;
                    if(is_boxnum == 1) shootingbox[num].is_exist = 1;
                    else shootingbox[old_num].color = (Color)num;
            }
        }
        old_num = num;
    }
}
