#include "discoveryboard.h"
#include "mbed.h"
#include "servo.h"
#include "coordinate.h"
#include "state.h"
#include "go.h"
#include "debug.h"
#include "pinnames.h"
#include "workinfo.h"
#include "filesystem.h"
//////////////////////////////変更できるパラメータ
const int kVelocity_mm = 1;
const int kDegreeVelocity_mm = 1;


//////////////////////////////
SPISlave spi(pin_spi_mosi, pin_spi_miso, pin_spi_sck, NC);
//int is_restart = 0;
const double kRadVelocity_mm = kDegreeVelocity_mm * kDegreeToRad;
int is_manual = 0;

void SaveAndReset();
void ManualMode();

void SpiSetup()
{
    spi.format(12,3);
    spi.frequency(1000000);
}
Pattern PatternSetupDiscovery()
{
    Pattern pat;
    if(spi.receive()) {
        int data = spi.read();
        switch((char)data) {
            case 'a':
                pat = A;
                break;
            case 'b':
                pat = B;
                break;
            case 'c':
                pat = C;
                break;
            case 'd':
                pat = D;
                break;
            default:
                pat = NOPATTERN;
        }
        spi.reply(data);
    } else pat = NOPATTERN;
    return pat;
}
void FullAutoRead()
{
    if(!spi.receive()) return;//s
    int spi_data = spi.read();
    spi.reply(spi_data);
    if(spi_data <= kCommonAreaNum) {
        work[spi_data - kWorkAreaNum - 1].is_exist = 0;
    } else if (spi_data == 18) {
        FileSave();
        NVIC_SystemReset();
    } else if(spi_data == 19) ManualMode();
}
enum ManualData {
    MANUAL_ZDOWN,
    MANUAL_ZUP,
    MANUAL_PITCHDOWN,
    MANUAL_PITCHUP,
    MANUAL_YAWDOWN,
    MANUAL_YAWUP,
    MANUAL_CLOSE,
    MANUAL_OPEN,
    MANUAL_YDOWN,
    MANUAL_YUP,
    MANUAL_XDOWN,
    MANUAL_XUP,
};
void ManualMode()
{
    is_manual = 1;
    LocateParam target;
    target.position[0] = GetNowTipLocateX();
    target.position[1] = GetNowTipLocateY();
    target.position[2] = GetNowTipLocateZ();
    target.yaw_rad = GetNowRad(2);
    target.pitch_rad = GetNowRad(3);
    int spi_data = 0;
    while(1) {
        if(spi.receive()) {
            spi_data = spi.read();
            spi.reply(spi_data);
        }

        if((spi_data >> MANUAL_ZDOWN)&1) target.position[2] -= kVelocity_mm;
        if((spi_data >> MANUAL_ZUP)&1) target.position[2] += kVelocity_mm;
        if((spi_data >> MANUAL_PITCHDOWN)&1) target.pitch_rad -= kRadVelocity_mm;
        if((spi_data >> MANUAL_PITCHUP)&1) target.pitch_rad += kRadVelocity_mm;
        if((spi_data >> MANUAL_YAWDOWN)&1) target.yaw_rad -= kRadVelocity_mm;
        if((spi_data >> MANUAL_YAWUP)&1) target.yaw_rad += kRadVelocity_mm;

        if((spi_data >> MANUAL_CLOSE)&1) Close();
        if((spi_data >> MANUAL_OPEN)&1) Open();
        if((spi_data >> MANUAL_YDOWN)&1)target.position[1] -= kVelocity_mm;
        if((spi_data >> MANUAL_YUP)&1)target.position[1] += kVelocity_mm;
        if((spi_data >> MANUAL_XDOWN)&1) target.position[0] -= kVelocity_mm;
        if((spi_data >> MANUAL_XUP)&1)target.position[0] += kVelocity_mm;
        spi_data = 0;

        AllTargetToElbow(target);
        CalServoMove(target, target);
        output = calpid.GetOutPut(target.elbow[2]);
        motor.OutPut(GetMotorOutPutZ());
        ServoMoveOnArm();
        wait_ms(3);
    }
}
int ManualModeWithPc()
{
    int yet = 1;
    LocateParam target;
    target.position[0] = GetNowTipLocateX();
    target.position[1] = GetNowTipLocateY();
    target.position[2] = GetNowTipLocateZ();
    target.yaw_rad = GetNowRad(2);
    target.pitch_rad = GetNowRad(3);
    if(pc.readable()) {
        switch(pc.getc()) {
            case 'd' :
                target.position[0] += kVelocity_mm;
                break;
            case 'a':
                target.position[0] -= kVelocity_mm;
                break;
            case 'w':
                target.position[1] += kVelocity_mm;
                break;
            case 's':
                target.position[1] -= kVelocity_mm;
                break;
            case 'r':
                target.position[2] += kVelocity_mm;
                break;
            case 'f':
                target.position[2] -= kVelocity_mm;
                break;
            case 'c':
                yet = 0;
                break;
        }
    }
    AllTargetToElbow(target);
    CalServoMove(target, target);
    output = calpid.GetOutPut(target.elbow[2]);
    motor.OutPut(GetMotorOutPutZ());
    ServoMoveOnArm();
    wait_ms(3);
    DEBUG("work %f, %f, %f\r\n", GetNowTipLocateX(), GetNowTipLocateY(), GetNowTipLocateZ());
    return yet;
}