#ifndef INCLUDED_CHECK_H
#define INCLUDED_CHECK_H
#include "state.h"
#include "mbed.h"
/** @file
@brief 現在値の情報から、動いてよいか等をチェック
*/
//禁止領域の名前
enum BanArea {
    BAN_SAFE = -1,
    BAN_COMMON,//共通エリア
    BAN_SHOOTINGBOX,//シューティングボックス下
    BAN_COMMONUP,//共通エリア上
    BAN_FRONTLEFT,//手前~アーム原点
    BAN_FRONTRIGHT,//右手前角周り
    BAN_FLOOR,//床
    //BAN_BACKLEFT,//手前~アーム原点の奥
    BAN_NUM,//禁止領域の数
};
extern double min_ban_area[][3];
extern const int kStopBuff_mm;
extern DigitalOut led[4];
///@brief checkの初期設定.禁止領域の中心などを計算
void CheckSetup();
///@brief 今アームを伸ばしてよいか調べる
///@return 入る禁止領域。入らなければ-1
int AllowChangeDirection(int target_is_yaw, double target_rad, LocateParam now);

/**到達したか調べる.(通りすぎているときは到達とみなさない。この関数を何回か読んで常に範囲ないならはじめて到達と認識）
@return 到達:1 未到達:0
*/
int IsArrived(const double (&target)[3], const double (&now_position_mm)[3]);

///@brief 目標値に行ってよいかどうかを判断。targetに目的地を入れると侵入禁止エリアに入らない値に変更する。
///@return 目標値を変更した:1 しなかった:0
int AvoidBanArea(const double (&now_position_mm)[3], double (&target)[3]);
///肘が禁止領域に入らない目標値に変更
///@return 目標値を変更した:1 しなかった:0
int AvoidElbowBan(LocateParam now, double (&target_mm)[3]);

/**
@param axis x:0, y:1, z:2
@param arm アームの状態の想定
*/
double CalMotorTargetLength(unsigned int axis,double target_tip_mm, WorkState &state);

///@return 引っかかる禁止領域のうち配列番号最大の値. 入らなければ-1.eroorなら-2 共通エリアなら0
int CheckBanArea(unsigned int axis,double target, const double (&now_position_mm)[3]);
///@brief 禁止領域から抜け出す
///@return 入っていたら1.入っていなければ0
int ExitBanArea(const double (&target)[3], LocateParam now, double (&result)[3]);
/*///@caution 一般的ではないので注意
void ChangeTargetForArmMove(int target_is_yaw, double target_rad, const double (&target_mm)[3],
                            double now_yaw_rad, double now_pitch_rad ,
                            double (&result)[3]);
*/
///@brief アームのyaw(pitch)が理想値になればreturn 1.無理なら動かせる
int ArmMove(int target_is_yaw, WorkState target, LocateParam now, LocateParam &safe);
///@brief 初期設定でワーク,ボックスの座標が禁止領域に入っていないかチェック
///@return 初期設定で禁止領域に入る:1, 入らない:0
int PositionSetupIsInBan();
#endif