#include "interrupt.h"
#include "mbed.h"
#include "debug.h"
#include "go.h"
#include "check.h"
#include "coordinate.h"
#include "pinnames.h"
#include "cat18_can_info.h"
#include "workinfo.h"
#include "calplace.h"
#include "pinnames.h"
#include "state.h"
#include "discoveryboard.h"
//#define CAN_ON //CAN通信するならdefine
Ticker ticker;
CAN can(pin_can_rd,pin_can_td);
int counterpart_is_in_common = 0;
char can_pub_data[kCanlength_rightleft];
//tickerタイミング計算関係
const double kTicker_s = 0.005;
const int kCanCount = kCanTicker_s / kTicker_s;
const int kPIDCount = kPIDTicker_s / kTicker_s;
const int kServoCount = kServoMoveTicker_s / kTicker_s;
const int kCalTargetCount = kCalTargetTicker_s  / kTicker_s;
const int kCountReset=kPIDCount*kCalTargetCount*kCanCount * kServoCount;

//tickerで呼び出す
void TimerInterrupt();
//CAN通信
void CanRead();
void CanSend();
void SpiRead();
void InterruptSetup()
{
    DEBUG("InterruptSetup() start\r\n");
    can.frequency(kCanFrequency);
    ticker.attach(TimerInterrupt,kTicker_s);
    DEBUG("InterruptSetup() finish\r\n");
}
void TimerInterrupt()
{
    if(is_manual == 1) return;
    static int count = 0;
    if(count % kPIDCount == 0) PIDInterrupt();
    if(count % kCalTargetCount == 0) CalTargetInterrupt();
    if(count % kServoCount == 0) ServoMoveInterrupt();
#ifdef CAN_ON
    if(count % kCanCount==0) {
        CanRead();
        CanSend();
    }
#endif
    if(count == kCountReset) count=0;
    count++;
}
int GetCounterpartIsInCommon()
{
    //一つもワークを置いていなければ入っていはいけない＝１
    if(shootingbox[kFirstPutPlace].is_exist == 0) return 1;
    return counterpart_is_in_common;
}
void CanRead()
{
    CANMessage msg;
    if(!can.read(msg)) {
        return;
    }
    switch (msg.id) {
#ifdef RIGHT
        case CANID_LEFT :
#elif defined LEFT
        case CANID_RIGHT :
#else
            DEBUG("error:There is no defined RIGHT/LEFT in CanRead\r\n");
#endif
            counterpart_is_in_common = msg.data[0];
            break;
    }
}
void CanSend()
{
    static int state = 1;
    switch(state) {
#ifdef RIGHT
        case CANID_RIGHT :
#elif defined LEFT
        case CANID_LEFT:
#else
            DEBUG("error:There is no defined RIGHT/LEFT in CanSend\r\n");
#endif
            {
                double now_position_mm[3] = {GetNowTipLocateX(),GetNowTipLocateY(),GetNowTipLocateZ()};
                if(CheckBanArea(0, now_position_mm[0], now_position_mm) == 0) can_pub_data[0] = 1;
                else can_pub_data[0] = 0;
                CANMessage msg(state,can_pub_data,kCanlength_rightleft);
                can.write(msg);
                break;
            }
    }
    state ++;
    if(state >= CANID_FINISH) {
        state = 1;
    }
}
void SpiRead()
{
}