#include "go.h"
#include "mbed.h"
#include "debug.h"
#include "servo.h"
#include "pinnames.h"
#include "check.h"
#include "coordinate.h"
#include "interrupt.h"
#include "controller.h"
#include "discoveryboard.h"
#include "workinfo.h"
#define FORDEBUG //DEBUGしないときはコメントアウト
//////////////////////////////変更するパラメータ群
//PID
const double kp = 0.053250, ki = 0.000042, kd = 0.000010;
const double kDutyMax = 0.3;
//ticker
const double kPIDTicker_s = 0.005;//PID出力計算間隔
const double kCalTargetTicker_s = 0.05;//目標位置計算間隔
const double kServoMoveTicker_s = 0.005;//サーボ出力間隔
//GoTo0
const double kSlowDuty = 0.2;
const double kSlowUpPosi_mm = -100;//encoderがいくつになればゆっくりにするか。エンコーダの値なので注意
const double kSlowDownPosi_mm = -250;//〃

//GetPrePosition
const int kCatchBuf_mm = 85;
const int kPitchPreBoxDegree = 45;
//サーボの移動速度[mm/s]
const double kServoVelocity_mm = 400;



//////////////////////////////
CalPID calpid(GetNowElbowZ, kp, ki, kd, kPIDTicker_s);
MotorOut motor(pin_motor[0][0],pin_motor[0][1], kDutyMax, 50);
DigitalIn limitZ(pin_touch_sensor[0], PullUp);
//タッチセンサが押してどの値を返すか
enum LimitZ {
    LIMITZON = 1,
    LIMITZOFF = 0,
};
double servo_dist_mm = kServoVelocity_mm* kCalTargetTicker_s ;//1 ticker毎に進むサーボの距離
double output = 0;
int cal_target_ticket = 0;
int motor_move_ticket = 0;
int servo_move_ticket = 0;



//目標値に行く。@return 成功:0 中断:-1
int MoveToTarget(WorkState target);
//粗移動でどこまで行くか
void GetPrePosition(WorkState state, WorkState &result);
//@brief ハンドを目的の形に変更
int HandSet(HandState hand);
//@brief 自陣エリアのワークを取る。z座標のみ動く
void CatchWorkArea(LocateParam target);

void GoSetup()
{
    DEBUG("GoSetup() start\r\n");
    CheckSetup();
    DEBUG("GoSetup() return\r\n");
}
int MoveToTarget(WorkState target)
{
    DEBUG("MoveToTarget start\r\n");
    DEBUG("target position %f, %f, %f\r\n",target.position[0], target.position[1], target.position[2]);
    DEBUG("yaw %f, pitch %f\r\n", target.yaw_rad*kRadToDegree, target.pitch_rad*kRadToDegree);
    //ret:返り値 中断したら-1.何も起こらなければ0
    int ret = 0, is_finish = 0, yaw_moved = 0, pitch_moved = 0;
    //pitch,yawを動かせる位置に1ループ分とどまるために指示変更をワンテンポずらす。そのためのold
    double old_safe[3] = {target.position[0], target.position[1], target.position[2]};
    calpid.PileReset();
    LocateParam safe;//特例としてelbowはサーボ2の位置とする。elbowそのものを示していないので注意
    while(is_finish == 0) {
        //現在地更新
        LocateParam now(GetNowTipLocateX(), GetNowTipLocateY(), GetNowTipLocateZ(),
                        GetNowElbowX(), GetNowElbowY(), GetNowElbowZ(),
                        GetNowRad(2),GetNowRad(3));
        if(cal_target_ticket == 1) {
            cal_target_ticket = 0;
            safe.yaw_rad = now.yaw_rad;
            safe.pitch_rad = now.pitch_rad;
            //収束したらその回でループ終了
            if(IsArrived(target.position, now.position) == 1) is_finish = 1;
            //禁止領域に入っていないか確認。入っていたら出る値に変更してその後のAvoid...は行わない。
            if(ExitBanArea(target.position, now, safe.position) == 0) {//禁止領域に入っていなければ
                //yawをうごかしてよいか調べる(既に動かしていたらスキップ）
                if(yaw_moved == 0) {
                    //アームを動かし終わるまで動かせる状態を変えないためにoldを使う
                    for(int i = 0; i < sizeof(safe.position)/sizeof(safe.position[0]); i++) {
                        safe.position[i] = old_safe[i];
                    }
                    yaw_moved = ArmMove(1, target, now, safe);
                    for(int i = 0; i < sizeof(old_safe)/sizeof(old_safe[0]); i++) {
                        old_safe[i] = safe.position[i];
                    }
                } else safe.yaw_rad = target.yaw_rad;
                //pitchをうごかしてよいか調べる.BOXに置くときしかBOX上でpitchを動かせない
                if(pitch_moved == 0) {
                    for(int i = 0; i < sizeof(safe.position)/sizeof(safe.position[0]); i++) {
                        safe.position[i] = old_safe[i];
                    }
                    pitch_moved = ArmMove(0, target, now, safe);
                    for(int i = 0; i < sizeof(old_safe)/sizeof(old_safe[0]); i++) {
                        old_safe[i] = safe.position[i];
                    }
                } else safe.pitch_rad = target.pitch_rad;
                //x,y,zバラバラに動いても禁止領域手前で止まるよう目標値変更
                if(AvoidBanArea(now.position, safe.position)) led[1] = 1;
                else led[1] = 0;
                //肘が禁止領域に入らない目標値に変更
                if(AvoidElbowBan(now, safe.position))led[2] = 1;
                else led[2] = 0;
                led[0] = 0;
            } else {
                led[0] = 1;
                led[1] = 0;
                led[2] = 0;
            }
            //目標値をサーボ2の位置に換算
            AllTargetToElbow(safe);
            //目標サーボ角度計算
            CalServoMove(safe, now);
            //ハンドのオープン、クローズをこまめに行い、脱力を防ぐ
            HandSet(target.hand);
#ifdef FORDEBUG
            static int count = 0;
            if(count > 50) {
                // DEBUG("target position %f, %f, %f\r\n",target.position[0], target.position[1], target.position[2]);
                DEBUG("safe.position %f, %f, %f\r\n", safe.position[0], safe.position[1], safe.position[2]);
                DEBUG("now %f, %f, %f\r\n",now.position[0],now.position[1],now.position[2]);
                DEBUG("now elbow %f, %f, %f\r\n", now.elbow[0],now.elbow[1],now.elbow[2]);
                DEBUG("now yaw %f  now pitch %f\r\n", now.yaw_rad * kRadToDegree, now.pitch_rad * kRadToDegree);
                DEBUG("now degree %f, %f, %f\r\n", GetNowRadRelative(0) * kRadToDegree, GetNowRadRelative(1)* kRadToDegree, GetNowRadRelative(2)* kRadToDegree);
                count = 0;
            }
            ++count;
#endif
        }
        //中断指示確認
        if(target.areaname != BOX && do_skip == 1) {
            DEBUG("skip\r\n");
            DEBUG("safe.position %f, %f, %f\r\n", safe.position[0], safe.position[1], safe.position[2]);
            DEBUG("now %f, %f, %f\r\n",now.position[0],now.position[1],now.position[2]);
            DEBUG("now elbow %f, %f, %f\r\n", now.elbow[0],now.elbow[1],now.elbow[2]);
            DEBUG("now yaw %f  now pitch %f\r\n", now.yaw_rad * kRadToDegree, now.pitch_rad * kRadToDegree);
            DEBUG("now degree %f, %f, %f\r\n", GetNowRadRelative(0) * kRadToDegree, GetNowRadRelative(1)* kRadToDegree, GetNowRadRelative(2)* kRadToDegree);
            do_skip = 0;
            ret = -1;
            break;
        }
        //motor出力
        if(motor_move_ticket > 0) {
            motor_move_ticket = 0;
            output = calpid.GetOutPut(safe.elbow[2]);
            #ifdef NOTZMOVE
            nowz = safe.elbow[2];
            #endif
            motor.OutPut(GetMotorOutPutZ());
        }
        //servoの出力値計算
        if(servo_move_ticket > 0) {
            servo_move_ticket = 0;
            ServoMoveOnArmInTurns();
        }
    }
    ServoMoveOnArm();
    motor.OutPut(0);
    DEBUG("MoveToTarget return %d now %f, %f, %f degree %f, %f, %f\r\n",
          ret, GetNowTipLocateX(), GetNowTipLocateY(), GetNowTipLocateZ(),
          GetNowRadRelative(0) * kRadToDegree, GetNowRadRelative(1)* kRadToDegree, GetNowRadRelative(2)* kRadToDegree);
    return ret;
}
int Go(WorkState workstate)
{
    DEBUG("Go start\r\n");
    //移動は2段階に分ける。目標値1段階目
    WorkState preposition;
    GetPrePosition(workstate, preposition);
    //目標値に行く
    if(MoveToTarget(preposition) != 0) return -1;
    switch(workstate.areaname) {
        case WORKAREA: {
            workstate.hand  = OPEN;
            Open();
            //手動で取る
            LocateParam temp = ManualPutPlace(workstate, 30);
            workstate.position[0] = temp.position[0];
            workstate.position[1] = temp.position[1];
            //下に下がるだけ
            CatchWorkArea(workstate);
            break;
        }
        case COMMONAREA:
            workstate.hand = OPEN;
            Open();
            //ボタンEで共通エリアに侵入。Cでスキップ
            while(buttonE == BUTTON_OFF) if(buttonC == BUTTON_ON) return -1;
        case BOX:
            //目標値2段階目(ワーク位置)
            if(MoveToTarget(workstate) != 0) return -1;
            break;
    }
    DEBUG("Go return\r\n");
    return 0;
}

void Above(AreaName areaname)
{
    DEBUG("Above start\r\n");
    double target_mm = GetNowElbowZ() + kCatchBuf_mm;
    switch(areaname) {
        case WORKAREA:
            calpid.PileReset();
            #ifndef NOTZMOVE
            while(GetNowElbowZ() < target_mm) {
                output = calpid.GetOutPut(target_mm);;
                motor.OutPut(GetMotorOutPutZ());
            }
            #endif
            motor.OutPut(0);
            break;
        case COMMONAREA:
        case BOX:
            for(int i=0; i<2; i++)ServoRad(3, kPitchPreBoxDegree * kDegreeToRad);
            break;
    }
    DEBUG("Above return\r\n");
}
void GetPrePosition(WorkState state, WorkState &result)
{
    DEBUG("GetPrePosition start\r\n");
    result = state;
    switch(state.areaname) {
        case WORKAREA:
            result.position[2] += kCatchBuf_mm;
            if(state.color == RED) result.yaw_rad = 210 * kDegreeToRad;
            break;
        case COMMONAREA:
            result.position[1] = min_ban_area[BAN_COMMON][1] - kStopBuff_mm;
            result.position[2] += kCatchBuf_mm;
            break;
        case BOX:
            double ideal_pitch_rad = GetIdealPitchRad(state);
            result.pitch_rad = kPitchPreBoxDegree * kDegreeToRad;
            result.position[1] += kArmLength[3] * cos(result.pitch_rad) - kArmLength[3] * cos(ideal_pitch_rad);
            result.position[2] += kArmLength[3] * sin(result.pitch_rad) - kArmLength[3] * sin(ideal_pitch_rad);
            break;
    }
    result.hand = CLOSE;
    DEBUG("GetPrePosition return\r\n");
}
void GoToZeroSlowly()
{
    DEBUG("GoToZeroSlowly() start\r\n");
    DEBUG("pre limit switch is %d\r\n",(int)limitZ);
    while(limitZ == LIMITZOFF) {
        output = kSlowDuty;
        motor.OutPut(GetMotorOutPutZ());
    }
    motor.OutPut(0);
    DEBUG("return limit switch is %d\r\n",(int)limitZ);
    wait(0.1);
    ec.Reset();
    DEBUG("GoToZeroSlowly() return\r\n");
}
void CalServoMove(LocateParam safe, LocateParam now)
{
    AllTargetToElbow(now);
    double target[2] = {safe.elbow[0], safe.elbow[1]};
    double diff[2]  = {target[0] - now.elbow[0], target[1] - now.elbow[1]};
    double rad[2] = {GetNowRad(0),GetNowRad(1)};//絶対座標での角度
    double dist = hypot(diff[0], diff[1]);
    if(dist > servo_dist_mm) {
        for(int i = 0; i < sizeof(target)/sizeof(target[0]); i++) {
            target[i] = servo_dist_mm / dist * diff[i] + now.elbow[i];
        }
    }
    //DEBUG("target %f,%f\r\n", target[0], target[1]);
    Set2LinkRad(target[0] - kArmOrigin[0], target[1] - kArmOrigin[1]);
    SetServoYawRad(safe.yaw_rad);
    SetServoPitchRad(safe.pitch_rad);
}
double GetMotorOutPutZ()
{
    if(limitZ == LIMITZON) {
        ec.Reset();
        if(output > 0) output = 0;
    }
    if(ec.GetDistance_mm() > kSlowUpPosi_mm && output > kSlowDuty) output = kSlowDuty;
    if(ec.GetDistance_mm() < kSlowDownPosi_mm && output < -kSlowDuty) output = -kSlowDuty;
    return output;
}
void GoToFirstPosition()
{
    DEBUG("StartCheck start\r\n");
    output = -kSlowDuty;
    motor.OutPut(GetMotorOutPutZ());
    wait(0.1);
    motor.OutPut(0);
    GoToZeroSlowly();
    ServoRad(3, 45*kDegreeToRad);
    wait(1);
    SetNextRadRelative(0, -60*kDegreeToRad);
    SetNextRadRelative(1, 120*kDegreeToRad);
    SetNextRadRelative(3, 45*kDegreeToRad);
    SetServoYawRad(0);
    ServoMoveOnArm();
    DEBUG("now deg %f,%f,%f\r\n", GetNowRad(0) * kRadToDegree, GetNowRad(1) * kRadToDegree, GetNowRad(2) * kRadToDegree);
    Close();
    wait(1);
    Open();
    wait(1);
    Close();
    DEBUG("StartCheck return\r\n");
}
int HandSet(HandState hand)
{
    switch(hand) {
        case OPEN:
            Open();
            break;
        case CLOSE:
            Close();
            break;
    }
    return 1;
}
void AllTargetToElbow(LocateParam &safe)
{
    for(int i = 0; i < sizeof(safe.elbow)/sizeof(safe.elbow[0]); i++) {
        safe.elbow[i] = safe.position[i] - GetFromElbowToHand(i, safe.yaw_rad, safe.pitch_rad);
    }
    safe.elbow[0] -= kArmLength[2] * cos(safe.yaw_rad);
    safe.elbow[1] -= kArmLength[2] * sin(safe.yaw_rad);
}
void MoveToPut(LocateParam target)
{
    target.position[0] -= 30;
    AllTargetToElbow(target);
    CalServoMove(target, target);
    ServoMoveOnArm();
    target.position[1] += 30;
    AllTargetToElbow(target);
    CalServoMove(target, target);
    ServoMoveOnArm();
}
void CatchWorkArea(LocateParam target)
{
    calpid.PileReset();
    int is_finish = 0;
    while(is_finish == 0) {
        HandSet(OPEN);
        wait_ms(kServoSpan_ms);
        //現在地更新
        LocateParam now(GetNowTipLocateX(), GetNowTipLocateY(), GetNowTipLocateZ(),
                        GetNowElbowX(), GetNowElbowY(), GetNowElbowZ(),
                        GetNowRad(2),GetNowRad(3));
        //収束したらその回でループ終了
        if(IsArrived(target.position, now.position) == 1) is_finish = 1;
        AllTargetToElbow(target);
        //ハンドのオープン、クローズをこまめに行い、脱力を防ぐ
        output = calpid.GetOutPut(target.elbow[2]);
        #ifdef NOTZMOVE
        nowz = target.elbow[2];
        #endif
        motor.OutPut(GetMotorOutPutZ());
    }
}