#include "check.h"
#include "mbed.h"
#include "state.h"
#include "coordinate.h"
#include "debug.h"
#include "go.h"
#include "interrupt.h"
#include "workinfo.h"

#define FORDEBUG
//////////////////////////////変更するパラメータ
//禁止領域
const int kBuffer_mm = 0;//禁止領域の余裕.先端で考えるため、横にはみ出る分を考慮する必要あり
const int kStopBuff_mm = 20;//停止する距離(実際はkBuffer_mmを含むのでもっと手前で止まる)
const int kMaxField_mm = 1350;//フィールドの端。禁止領域の座標の最大値

//禁止領域の指定[mm]{x,y,z}座標
double min_ban_area[BAN_NUM][3] = {
    {-675, 450, -460},//共通エリア
    {-179+30, 135, -kMaxField_mm},//シューティングボックス下
    {-kMaxField_mm, 450, -100},//共通エリア上
    {-kMaxField_mm, -kMaxField_mm, -kMaxField_mm},//手前~アーム原点
    {-110, -kMaxField_mm, -kMaxField_mm},//右手前角周り
    {-kMaxField_mm, -kMaxField_mm, -kMaxField_mm},//床
    //{-kMaxField_mm, 70, -kMaxField_mm},//手前~アーム原点の奥
};
double max_ban_area[BAN_NUM][3] = {
    {0, kMaxField_mm, -100},//共通エリア
    {kMaxField_mm, kMaxField_mm, 120},//シューティングボックス下
    {kMaxField_mm, kMaxField_mm, kMaxField_mm},//共通エリア上
    {-110, 129, kMaxField_mm},//手前~アーム原点
    {kMaxField_mm, 150, 120},//右手前角周り
    {kMaxField_mm, kMaxField_mm,-430},//床
    //{-110, 135, 70}, //手前~アーム原点の奥
};

//IsArrived(収束判定)
const double kArrivedTime_s = 0.25;
const double kTorelance_mm = 2;

//////////////////////////////
DigitalOut led[] = {LED1, LED2, LED3, LED4};
double center[BAN_NUM][3];
const int kArrivedCount = kArrivedTime_s / kCalTargetTicker_s;
//@return 引っかかる禁止領域の入っている配列の番号. 入らなければ-1.eroorなら-2
int CheckBanArea(unsigned int axis,double target, const double (&now_position_mm)[3]);
//角度を0から360にして返す。
double DegreeMinus90To270(double degree);

void ChangeTargetForArmMove(int target_is_yaw, double target_rad, const double (&target_mm)[3],
                            double now_yaw_rad, double now_pitch_rad, int out_area_num,
                            double (&result)[3]);

void CheckSetup()
{
    DEBUG("CheckSetup() start\r\n");
    EcSetup();
    for(int j = 0; j < BAN_NUM; j++) {
        for(int i = 0; i < 3; i++) {
            min_ban_area[j][i] -= kBuffer_mm;//余裕を持たせる.値はてきとう。あとから決める
            max_ban_area[j][i] += kBuffer_mm;
            center[j][i] = (min_ban_area[j][i] + max_ban_area[j][i]) / 2.0;
            if(min_ban_area[j][i] > max_ban_area[j][i]) {
                DEBUG("miss : min > max [%d][%d]\r\n",j,i);
            }
        }
    }
    DEBUG("CheckSetup() finish\r\n");
}
int PositionSetupIsInBan()
{
    int is_out = 0;
    for(int i = 0; i < kWorkAreaNum + kCommonAreaNum; i++) {
        int out_area_num = CheckBanArea(0, work[i].position[0], work[i].position);
        if(out_area_num != BAN_SAFE && out_area_num != BAN_COMMON) {
            is_out = 1;
            DEBUG("miss : work[%d] %f, %f, %f is in ban area %d\r\n", i, work[i].position[0], work[i].position[1], work[i].position[2], out_area_num);
        }
    }
    for(int i = 0; i < kBoxNum; i++) {
        int out_area_num = CheckBanArea(0, shootingbox[i].position[0], shootingbox[i].position);
        if(out_area_num != BAN_SAFE && out_area_num != BAN_COMMON) {
            is_out = 1;
            DEBUG("miss : box[%d] %f, %f, %f is in ban area %d\r\n", i, shootingbox[i].position[0], shootingbox[i].position[1], shootingbox[i].position[2], out_area_num);
        }
    }
    return is_out;
}
int IsArrived(const double (&target)[3], const double (&now_position_mm)[3])
{
    int result;
    static int count = 0;

    if(
#ifdef NOTZMOVE
        fabs(now_position_mm[0]-target[0])<kTorelance_mm &&
        fabs(now_position_mm[1]-target[1])<kTorelance_mm)
#else
        fabs(now_position_mm[0]-target[0])<kTorelance_mm &&
        fabs(now_position_mm[1]-target[1])<kTorelance_mm &&
        fabs(now_position_mm[2]-target[2])<kTorelance_mm)
#endif
    {
        count++;
    } else count=0;
    if(count >= kArrivedCount) {
        result=1;
        count = 0;
    } else {
        result=0;
    }
    return result;
}
///@return 引っかかる禁止領域のうち配列番号最大の値. 入らなければ-1.eroorなら-2 共通エリアなら0
int CheckBanArea(unsigned int axis,double target, const double (&now_position_mm)[3])
{
    if(axis > 3) {
        DEBUG("error: axis is x:0, y:1, z:2. In CheckBanArea\r\n");
        return -2;
    }
    //現在地の取得
    double check[3] = {};
    for(int i = 0; i < sizeof(check)/sizeof(check[0]); i++) check[i] = now_position_mm[i];
    check[axis] = target;
    int out_area_num = BAN_SAFE;
    for(int i=0; i<BAN_NUM; i++) {
//禁止領域を立方体として考えてる)
        if(     min_ban_area[i][0] < check[0] && check[0] < max_ban_area[i][0] &&
                min_ban_area[i][1] < check[1] && check[1] < max_ban_area[i][1] &&
                min_ban_area[i][2] < check[2] && check[2] < max_ban_area[i][2]) {
            out_area_num = i;
        }
    }
    return out_area_num;
}
int AvoidBanArea(const double (&now_position_mm)[3], double (&target)[3])
{
    int is_out = 0;//目標値を変更したら1
    double result[3] = {};
    for(int i = 0; i < sizeof(result)/sizeof(result[0]); i++) {
        int out_area_num = CheckBanArea(i, target[i], now_position_mm);
        //禁止領域入っていない or 共通エリアに相手が入っていない
        if(out_area_num <= BAN_SAFE || (out_area_num == BAN_COMMON && GetCounterpartIsInCommon() == 0)) {
            result[i] = target[i];
        } else {
            //禁止領域の直前の値を返す。
            if(now_position_mm[i] <= center[out_area_num][i]) result[i] = min_ban_area[out_area_num][i] - kStopBuff_mm;
            else result[i] = max_ban_area[out_area_num][i] + kStopBuff_mm;
            is_out = 1;
#ifdef FORDEBUG
            static int count = 0;
            if(count > 100) {
                DEBUG("AvoidBanArea area %d axis %d %f\r\n",out_area_num, i, result[i]);
                //DEBUG("now %f, %f, %f\r\n",now_position_mm[0],now_position_mm[1],now_position_mm[2]);
                count = 0;
            }
            ++count;
#endif
        }
    }
    for(int i = 0; i < sizeof(target)/sizeof(target[0]); i++) {
        target[i] = result[i];
    }
    return is_out;
}
int AvoidElbowBan(LocateParam now, double (&target_mm)[3])
{
    int is_out = 0;//目標値を変更したら1
    double result[3] = {};
    double next_elbow[3] = {};//次の肘の値
    for(int i = 0; i < sizeof(next_elbow)/sizeof(next_elbow[0]); i++) {
        next_elbow[i] = target_mm[i] - GetFromElbowToHand(i, now.yaw_rad, now.pitch_rad);
    }
    for(int i = 0; i < sizeof(result)/sizeof(result[0]); i++) {
        int out_area_num = CheckBanArea(i, next_elbow[i], now.elbow);
        //禁止領域入っていない or 共通エリアに相手が入っていない
        if(out_area_num <= BAN_SAFE || (out_area_num == BAN_COMMON && GetCounterpartIsInCommon() == 0)) {
            result[i] = target_mm[i];
        } else {
            //禁止領域の直前の値を返す。
            if(now.position[i] <= center[out_area_num][i]) {
                result[i] = min_ban_area[out_area_num][i] - kStopBuff_mm
                            + GetFromElbowToHand(i, now.yaw_rad, now.pitch_rad);
            } else {
                result[i] = max_ban_area[out_area_num][i] + kStopBuff_mm
                            + GetFromElbowToHand(i, now.yaw_rad, now.pitch_rad);
            }
            is_out = 1;
#ifdef FORDEBUG
            static int count = 0;
            if(count > 100) {
                DEBUG("AvoidElbowBan area %d axis %d %f\r\n",out_area_num, i, result[i]);
                //DEBUG("now elbow %f, %f, %f\r\n",now.position[0],now.position[1],now.position[2]);
                count = 0;
            }
            ++count;
#endif
        }
    }
    for(int i = 0; i < sizeof(target_mm)/sizeof(target_mm[i]); i++) {
        target_mm[i] = result[i];
    }
    return is_out;
}

int AllowChangeDirection(int target_is_yaw, double target_rad, LocateParam now)
{
    //角度は度単位で整数精度でしか考えない
    int degree[2] = {};//degree[0]:min, degree[1]:max
    if(target_is_yaw == 1) degree[0] = DegreeMinus90To270(now.yaw_rad * kRadToDegree);
    else degree[0] = DegreeMinus90To270(now.pitch_rad * kRadToDegree);
    degree[1] = DegreeMinus90To270(target_rad * kRadToDegree);
    if(degree[0] > degree[1]) {
        int temp = degree[0];
        degree[0] = degree[1];
        degree[1]= temp;
    }
    //数値解的に解く。全座標で通過しないか調べる
    double next[360][3] = {};
    for(int j = 0; j < degree[1] - degree[0]; j++) {
        for(int i = 0; i < 3; i++) {
            if(target_is_yaw == 1) {
                next[j][i] = now.elbow[i] + GetFromElbowToHand(i, (degree[0] + j) * kDegreeToRad, now.pitch_rad);
            } else next[j][i] = now.elbow[i] + GetFromElbowToHand(i, now.yaw_rad, (degree[0] + j) * kDegreeToRad);
        }
        int out_area_num = CheckBanArea(0, next[j][0], next[j]);
        if(out_area_num <= BAN_SAFE || (out_area_num == BAN_COMMON && GetCounterpartIsInCommon() == 0)) {}
        else return out_area_num;//どこかの禁止領域に入っていれば0
    }
    return BAN_SAFE;//全禁止領域に入らなければBAN_SAFE
}

double DegreeMinus90To270(double degree)
{
    int is_finish = 0;
    while(is_finish == 0) {
        if(degree < -90) degree += 360;
        else if(degree > 270) degree -= 360;
        else is_finish = 1;
    }
    return degree;
}
//各禁止座標毎に具体的に変更決定
int ExitBanArea(const double (&target)[3], LocateParam now, double (&result)[3])
{
    int is_ban_area = 1;
    int ban_area[2] = {BAN_SAFE,BAN_SAFE};//[0]:先端が入っている禁止領域,[1]:肘が入っている禁止領域
    int out_area_num = BAN_SAFE;//禁止領域で最大のもの
    int is_tip_ban = 0;//tipが禁止領域に入っていると1
    for(int i = 0; i < sizeof(result)/sizeof(result[0]); i++) result[i] = target[i];
    //先端のチェック{
    ban_area[0] = CheckBanArea(0, now.position[0], now.position);
    //肘のチェック
    ban_area[1] = CheckBanArea(0, now.elbow[0], now.elbow);
    //禁止領域最大のものを決定
    if(ban_area[0] > ban_area[1]) {
        out_area_num = ban_area[0];
        is_tip_ban = 1;
    } else out_area_num = ban_area[1];
    switch(out_area_num) {
        case BAN_SAFE://禁止領域に入っていない
            is_ban_area = 0;
            break;
        case BAN_COMMON://共通エリア
            if(GetCounterpartIsInCommon() == 0) is_ban_area = 0;
            else result[1] = min_ban_area[out_area_num][1] - kStopBuff_mm
                                 - GetFromElbowToHand(1, now.yaw_rad, 0);
            break;
        case BAN_COMMONUP://共通エリア上
            result[1] = min_ban_area[out_area_num][1] - kStopBuff_mm
                        - GetFromElbowToHand(1, now.yaw_rad, 0);
            break;
        case BAN_FRONTRIGHT://アーム初期位置下
        case BAN_FRONTLEFT://手前~アーム原点
            if(is_tip_ban)result[1] = max_ban_area[out_area_num][1]  + kStopBuff_mm;
            else {
                result[1] = max_ban_area[out_area_num][1]  + kStopBuff_mm
                            + GetFromElbowToHand(1, now.yaw_rad, now.pitch_rad);
            }
            result[2] = max_ban_area[out_area_num][2]  + kStopBuff_mm
                        + GetFromElbowToHand(2, now.yaw_rad, now.pitch_rad);
            break;
        case BAN_SHOOTINGBOX: {
            double temp = min_ban_area[out_area_num][0] - kStopBuff_mm
                          - fabs(GetFromElbowToHand(0, now.yaw_rad, 0));
            if(temp < result[0]) result[0] = temp;
            if(is_tip_ban)result[2] = max_ban_area[out_area_num][2]  + kStopBuff_mm;
            else {
                result[2] = max_ban_area[out_area_num][2]  + kStopBuff_mm
                            + GetFromElbowToHand(2, now.yaw_rad, now.pitch_rad);
            }
            break;
        }
        case BAN_FLOOR://床
            result[2] = max_ban_area[out_area_num][2]  + kStopBuff_mm;
            break;
        default:
            result[1] = min_ban_area[out_area_num][1] - kStopBuff_mm
                        - GetFromElbowToHand(1, now.yaw_rad, now.pitch_rad);
            result[2] = max_ban_area[out_area_num][2]  + kStopBuff_mm
                        + GetFromElbowToHand(2, now.yaw_rad, now.pitch_rad);
    }
#ifdef FORDEBUG
    static int count = 0;
    if(count > 100) {
        DEBUG("ExitBanArea %d %f,%f,%f\r\n", out_area_num, result[0], result[1], result[2]);
        count = 0;
    }
    ++count;
#endif
    return is_ban_area;
}
//一般的ではないので注意
void ChangeTargetForArmMove(int target_is_yaw, double target_rad, const double (&target_mm)[3],
                            double now_yaw_rad, double now_pitch_rad, int out_area_num,
                            double (&result)[3])
{
    for(int i = 0; i < 3; i++) result[i] = target_mm[i];
//入るエリアごとに指示変更
    switch(out_area_num) {
        case BAN_SAFE://どこにも入らない
            break;//指示変更しない
        case BAN_COMMON://共通エリア
            if(GetCounterpartIsInCommon() == 1) {
                if(target_is_yaw) {
                    result[1] = min_ban_area[out_area_num][1] - kStopBuff_mm
                                - GetFromElbowToHand(1, 90 * kDegreeToRad, now_pitch_rad);
                } else {
                    result[1] = min_ban_area[out_area_num][1] - kStopBuff_mm
                                - GetFromElbowToHand(1, now_yaw_rad, 0 * kDegreeToRad)
                                + GetFromElbowToHand(1, now_yaw_rad, now_pitch_rad);
                }
            }
            break;
        case BAN_FRONTRIGHT://アーム初期位置下
        case BAN_FRONTLEFT://手前~アーム原点
            if(target_is_yaw) {
                result[1] = max_ban_area[out_area_num][1] + kStopBuff_mm
                            + 2 * GetFromElbowToHand(1, 90 * kDegreeToRad, now_pitch_rad);

            } else {
                result[1] = max_ban_area[out_area_num][1] + kStopBuff_mm
                            + fabs(GetFromElbowToHand(1, now_yaw_rad, 0));
            }
            break;
        case BAN_COMMONUP://共通エリア上
            if(target_is_yaw) {
                result[1] = min_ban_area[out_area_num][1] - kStopBuff_mm
                            - GetFromElbowToHand(1, 90 * kDegreeToRad, now_pitch_rad);
            } else {
                result[1] = min_ban_area[out_area_num][1] - kStopBuff_mm
                            - GetFromElbowToHand(1, now_yaw_rad, 0 * kDegreeToRad)
                            + GetFromElbowToHand(1, now_yaw_rad, now_pitch_rad);
                result[2] = min_ban_area[out_area_num][2] - kStopBuff_mm;
            }
            break;
        case BAN_SHOOTINGBOX: {
            double temp = min_ban_area[out_area_num][0] - kStopBuff_mm
                          - fabs(GetFromElbowToHand(0, now_yaw_rad, 0));
            if(temp < result[0]) result[0] = temp;
            break;
        }
        case BAN_FLOOR:
            if(target_is_yaw) {
            } else {
                result[2] +=  kStopBuff_mm
                              - GetFromElbowToHand(2, now_yaw_rad, target_rad)
                              + GetFromElbowToHand(2, now_yaw_rad, now_pitch_rad);
            }
            break;
    }
#ifdef FORDEBUG
    static int count = 0;
    if(count > 100) {
        DEBUG("ChangeTargetForArmMove outarea %d %f, %f, %f\r\n", out_area_num, result[0], result[1], result[2]);
        count = 0;
    }
    ++count;
#endif
}
int ArmMove(int target_is_yaw, WorkState target, LocateParam now, LocateParam &safe)
{
    int moved = 0;
    double now_rad = 0, target_rad = 0;
    if(target_is_yaw) {
        now_rad = now.yaw_rad ;
        target_rad = target.yaw_rad;
    } else {
        now_rad = now.pitch_rad ;
        target_rad = target.pitch_rad;
    }
//理想位置になっているか確認
    if((int)(now_rad * kRadToDegree) == (int)(target_rad * kRadToDegree)) moved = 1;
//今動かして入る禁止領域があるか確認
    int out_area_num = AllowChangeDirection(target_is_yaw, target_rad, now);
    if(out_area_num == BAN_SAFE) {
        if(target_is_yaw) safe.yaw_rad = target_rad;
        else {
            if(target.areaname == BOX || now.elbow[0] < min_ban_area[BAN_SHOOTINGBOX][0]) {
                safe.pitch_rad = target_rad;
            }
        }
    } else {
        //一般的ではないので注意
        double temp[3] = {safe.position[0], safe.position[1], safe.position[2]};
        ChangeTargetForArmMove(target_is_yaw, target_rad, temp,
                               now.yaw_rad, now.pitch_rad ,out_area_num,
                               safe.position);
    }
    return moved;
}