#include "controller.h"
#include "mbed.h"
#include "state.h"
#include "workinfo.h"
#include "calplace.h"
#include "pinnames.h"
#include "filesystem.h"
#include "debug.h"
#include "coordinate.h"
#include "servo.h"
#include "go.h"
#include "check.h"
//#define FORDEBUG
//////////////////////////////変更できるパラメータ


DigitalIn buttonA(pin_button[0],PullUp);
DigitalIn buttonB(pin_button[1],PullUp);
DigitalIn buttonC(pin_button[2],PullUp);
DigitalIn buttonD(pin_button[3],PullUp);
DigitalIn buttonE(pin_button[4],PullUp);

int pre_skip = 0;
int do_skip = 0;
//SkipNextWorkの前に呼ばれる。
void PreSkipNextWork();
//誤動作防止のため先にPreSkipNextWorkを呼ぶ必要あり。呼んでいなければ何もしない
void SkipNextWork();
Pattern PatternSetup()
{
    //DEBUG("button %d, %d, %d, %d\r\n", buttonA.read(),buttonB.read(),buttonC.read(),buttonD.read());
    Pattern pat;
    if(buttonA.read() == BUTTON_ON) pat = A;
    else if(buttonB.read() == BUTTON_ON) pat = B;
    else if(buttonC.read() == BUTTON_ON) pat = C;
    else if(buttonD.read() == BUTTON_ON) pat = D;
    else pat = NOPATTERN;
    return pat;
}
int PermitStart()
{
    int canstart = 0;
    now_pattern = PatternSetup();
    if(now_pattern != NOPATTERN) {
        ArrangementPattern(now_pattern);
        YawPitchSetup();
        canstart = 1;
    }
    return canstart;
}

LocateParam ManualPutPlace(LocateParam target, int velocity_mm)
{
    DEBUG("ManualPutPlace start\r\n");
    int is_finish = 0;
    while(is_finish == 0) {
        if(buttonE == BUTTON_ON) {
            is_finish = 1;
        } else {
            if(buttonA == BUTTON_ON) target.position[1] += velocity_mm;
            if(buttonD == BUTTON_ON) target.position[1] -= velocity_mm;
#ifdef RIGHT
            if(buttonB == BUTTON_ON) target.position[0] += velocity_mm;
            if(buttonC == BUTTON_ON) target.position[0] -= velocity_mm;
#elif defined LEFT
            if(buttonB == BUTTON_ON) target.position[0] -= velocity_mm;
            if(buttonC == BUTTON_ON) target.position[0] += velocity_mm;
#else
            DEBUG("error: There is no define RIGHT/LEFT in ManualPutPlace\r\n");
#endif
        }
        AllTargetToElbow(target);
        CalServoMove(target, target);
        ServoMoveOnArm();
        DEBUG("now %f, %f, %f degree %f, %f, %f\r\n", GetNowTipLocateX(), GetNowTipLocateY(), GetNowTipLocateZ(),
              GetNowRadRelative(0) * kRadToDegree, GetNowRadRelative(1)* kRadToDegree, GetNowRadRelative(2)* kRadToDegree);
    }
    for(int i = 0; i < 2; i++) ServoRad(3, target.pitch_rad);
    DEBUG("ManualPutPlace() return now %f, %f, %f\r\n", GetNowTipLocateX(), GetNowTipLocateY(), GetNowTipLocateZ());
    return target;
}
void PreSkipNextWork()
{
    ++pre_skip;
    if(pre_skip > 1) {
        pre_skip = 0;
    }
    led[3] = pre_skip;
}
void SkipNextWork()
{
    if(pre_skip == 1) {
        led[3] = 0;
        work[CalPickPlace()].is_exist = 0;
        pre_skip = 0;
        do_skip = 1;
    }
}