#include "mbed.h"

Serial pc(USBTX,USBRX);
SPISlave spi(PA_7,PA_6,PA_5,PA_4);
PwmOut moter_1(PB_14);
PwmOut moter_2(PB_15);
DigitalOut cyli_1(PB_5);
DigitalOut cyli_2(PB_3);
DigitalOut cyli_3(PA_10);
//フォトインタラプタ上
InterruptIn photo_1(PC_2);
//フォトインタラプタ下
InterruptIn photo_2(PC_3);

int L_up,L_down,L_open,L_close,R_up,R_down,R_open,R_close;

//モーターの出力の設定
double moter_power = 0.7;


//腕上昇下降の関数
void up()
{
    moter_1=moter_power;
    moter_2=0;
}
void down()
{
    moter_1=0;
    moter_2=moter_power;
}
void stop()
{
    moter_1=0;
    moter_2=0;
}
//フラグ
int up_flag=1;
int down_flag=1;
//フォトトランジスタのフラグ呼び出し
void photo_1_rise()
{
    stop();
    up_flag=0;
}
void photo_1_fall()
{
    up_flag=1;
}
void photo_2_rise()
{
    stop();
    down_flag=0;
}
void photo_2_fall()
{
    down_flag=1;
}
int main()
{
    spi.format(8,3);
    spi.frequency(1000000);

//フォトインタラプタ１
    photo_1.rise(&photo_1_rise);
    photo_1.fall(&photo_1_fall);

//フォトインタラプタ２
    photo_2.rise(&photo_2_rise);
    photo_2.fall(&photo_2_fall);
    while(1) {

        if(spi.receive()) {

            int L_up = spi.read() & 0b1;
            int L_down = (spi.read() & 0b10)>>1;
            int L_open = (spi.read() & 0b100)>>2;
            int L_close = (spi.read() & 0b1000)>>3;
            int R_up = (spi.read() & 0b10000)>>4;
            int R_down = (spi.read() & 0b100000)>>5;
            int R_open = (spi.read() & 0b1000000)>>6;
            int R_close = (spi.read() & 0b10000000)>>7;

//spiの値プリント
            pc.printf("L_up:%d\tL_down:%d\tL_open:%d\tL_close:%d\t\nR_up:%d\tR_down:%d\tR_open:%d\tR_close:%d\tsend:%d\r\n",L_up,L_down,L_open,L_close,R_up,R_down,R_open,R_close,spi.read());

        }


//腕１　上昇下降
        if(L_up == 1 && up_flag==1) {//上昇
            up();
        } else if(L_down == 1 && down_flag==1) {//下降
            down();
        } else {
            stop();
        }

//腕１　開閉
        if(L_open == 1) {
            cyli_1=1;
        } else if(L_close == 1) {
            cyli_1=0;
        }

//腕２　上昇下降
        if(R_up == 1) {
            cyli_2=1;
        } else if(R_down == 1) {
            cyli_2=0;
        }

//腕２　開閉
        if(R_open == 1) {
            cyli_3=1;
        } else if(R_close == 1) {
            cyli_3=0;
        }
    }

}
