#include "mbed.h"

Serial pc(USBTX,USBRX);
BusIn in(PA_7,PA_6,PA_5,PA_4);
PwmOut motor_1(PB_14);
PwmOut motor_2(PB_15);
DigitalOut cyli_1(PB_5);
DigitalOut cyli_2(PB_3);
DigitalOut cyli_3(PA_10);
//フォトインタラプタ上
InterruptIn photo_1(PC_2);
//フォトインタラプタ下
InterruptIn photo_2(PC_3);

int num;

//モーターの出力の設定
double motor_power = 0.6;


//腕上昇下降の関数
void up()
{
    motor_1=0;
    motor_2=motor_power;
}
void down()
{
    motor_1=motor_power;
    motor_2=0;
}
void stop()
{
    motor_1=0;
    motor_2=0;
}
//フラグ
int up_flag=1;
int down_flag=1;
//フォトトランジスタのフラグ呼び出し
void photo_1_rise()
{
    stop();
    up_flag=0;
}
void photo_1_fall()
{
    up_flag=1;
}
void photo_2_rise()
{
    stop();
    down_flag=0;
}
void photo_2_fall()
{
    down_flag=1;
}
int main()
{
motor_1.period_us(100);
motor_2.period_us(100);

//フォトインタラプタ１
    photo_1.rise(&photo_1_rise);
    photo_1.fall(&photo_1_fall);

//フォトインタラプタ２
    photo_2.rise(&photo_2_rise);
    photo_2.fall(&photo_2_fall);
    while(1) {

        num=in;


//腕１　上昇下降
        if(num == 1 && up_flag==1) {//フラグ1で上昇
            up();
            num=1;
            pc.printf("up\n");
        } else if(num == 2 && down_flag==1) {//フラグ1で下降
            down();
            num=2;
            pc.printf("down\n");
        } else {//止まる
            stop();
        }

//腕１　開閉
        if(num == 3) {//開く
            cyli_1=1;
        } else if(num == 4) {//閉じる
            cyli_1=0;
        }

//腕２　上昇下降
        if(num == 5) {//上昇
            cyli_2=0;
        } else if(num == 6) {//下降
            cyli_2=1;
        }

//腕２　開閉
        if(num == 7) {//開く
            cyli_3=1;
        } else if(num == 8) {//閉じる
            cyli_3=0;
        }
        pc.printf("%d\n\r",num);
    }
}
