#include "mbed.h"

#define PING_ERR    0xFFFF

Timer timer1;
Timer ping_t;
DigitalOut myled(LED1);


uint16_t readPing (void)
{
    
    DigitalOut PingPinOut(p10);
    PingPinOut = 1;
    wait_us(10);
    PingPinOut = 0;
    DigitalIn PingPin(p10);
    //PingPin.mode(PullUp);
    timer1.reset();
    while(PingPin == 0){
        if(timer1.read_us() > 1000){   //1ms以上応答なし
            //pc.printf("1ms\n");
            return PING_ERR;
        }
    } 
    timer1.reset();
    while(PingPin == 1){
        if(timer1.read_us() > 18500){  //18.5ms以上のパルス
            //printf("18.5ms\n");
            return PING_ERR;
        }
    } 
    
    return timer1.read_us() / 1000000.0 / 2.0 * 340.0 * 1000.0; //mm  MAX:3145;
}
/*
int ulutrasonic_time(int data){
    sum -= value[9];
    sum += data;
    value[9] = value[8];
    value[8] = value[7];
    value[7] = value[6];
    value[6] = value[5];
    value[5] = value[4];
    value[4] = value[3];
    value[3] = value[2];
    value[2] = value[1];
    value[1] = value[0];
    value[0] = data;
    
    return sum/10;
}*/

int ping_button(int ping,int button){
    static int continue_flag = 0;
    static int change_flag = 0;

    if(continue_flag == 0){
        if(ping <= 700){
            ping_t.start();
            continue_flag = 1;
        }
    }    
    
    if(continue_flag == 1){
        //agatterutoki
        if(ping <= 700){
            if(change_flag == 0){
                if(ping_t.read_ms() >= 300){
                    button = !button;
                    change_flag = 1;
                }
            }
        }
        //tatisagari
        if(ping >= 900){
            ping_t.stop();
            ping_t.reset();
            continue_flag = 0;
            change_flag = 0;
        }       
    }
    return button;    
}


int main(void)
{
    timer1.start();
    ping_t.start();
    
    int button;
    
    for(;;){
        button = ping_button(readPing(),button);
        
        if(button){
            myled = 1;
        }else{
            myled = 0;
        }
    }
}