#include "mbed.h"

#define KEYCODE 120
#define GOSA 8
 
BusOut mbedleds(LED4,LED3,LED2,LED1); 
 
Serial device(p13, p14);  // tx, rx

Serial pc(USBTX, USBRX); // tx, rx 

volatile int8_t data[8];
volatile uint8_t value[4];

void dev_rx () {
    static uint8_t count;
    
    data[count] = device.getc();
    
    if(data[0] == KEYCODE){
        count++;
    } else {
        count = 0;
        data[0] = 0;
        data[1] = 0;            //左スティック縦
        data[2] = 0;            //左スティック横
        data[3] = 0;            //右スティック縦
        data[4] = 0;            //右スティック横
        data[5] = 0;            //Lボタン
        data[6] = 0;            //Rボタン
        data[7] = 0;
    }
    if(count > 7){
        if(data[7] == (data[1] ^ data[2] ^ data[3] ^ data[4] ^ data[5] ^ data[6])){
            if(data[1] < 0){
                value[0] = (-(data[1] + data[1]));
            } else {
                value[0] = (data[1] + data[1]);
            }
            if(data[2] < 0){
                value[1] = (-(data[2] + data[2]));
            } else {
                value[1] = (data[2] + data[2]);
            }
            if(data[4] < 0){
                value[2] = (-(data[4] + data[4]));
            } else {
                value[2] = (data[4] + data[4]);
            }
        }
        count = 0;
    } 
       
}
 
int main() {
    device.baud(9600);
    device.attach(&dev_rx);
    
    for(;;){
        //pc.printf("%d\n",data[1]*-1);
        //pc.printf("%d\n",data[2]);
        //pc.printf("%d\n",data[4]);
    }
}
