#include "mbed.h"

#define PING_ERR    0xFFFF

Timer timer1;
Serial pc(USBTX, USBRX); // tx, rx 


uint16_t moving_ave_5point(uint16_t data)
{
    static uint16_t tmp[5] = {0};
    static uint32_t sum = 0;
    uint8_t i;
    uint8_t count;
    
    sum -= tmp[4];
    sum += data;
    tmp[4] = tmp[3];
    tmp[3] = tmp[2];
    tmp[2] = tmp[1];
    tmp[1] = tmp[0];
    tmp[0] = data;
    
    
    count = 0;
    for(i=0; i<5; i++){
        if(tmp[i] == PING_ERR){
            return PING_ERR;
        }
    }
    
    return sum/5;
}


uint16_t readPing (void)
{
    
    DigitalOut PingPinOut(p13);
    PingPinOut = 1;
    wait_us(10);
    PingPinOut = 0;
    DigitalIn PingPin(p13);
    //PingPin.mode(PullUp);
    timer1.reset();
    while(PingPin == 0){
        if(timer1.read_us() > 1000){   //1ms以上応答なし
            //pc.printf("1ms\n");
            return PING_ERR;
        }
    } 
    timer1.reset();
    while(PingPin == 1){
        if(timer1.read_us() > 18500){  //18.5ms以上のパルス
            //printf("18.5ms\n");
            return PING_ERR;
        }
    } 
    
    return timer1.read_us();
}

int main(void)
{

    timer1.start();
    
    for(;;){
        pc.printf("%d\n",moving_ave_5point(readPing()));
        
        wait_us(200);
    }
}
