#include "mbed.h"

#define IR_TIME_NOTFOUND 833    /* 見つけられなかったと判断するまでの時間(単位：us) */
#define IR_COUNTMAX 487     /*最大パルス幅 パルスの存在しうる最大時間は487us*/
#define ALL_IR 8

Serial pc(USBTX, USBRX); // tx, rx 

Timer timer_ir;     /* 赤外線用タイマー */

BusOut myleds(p18, p17, p16, p15, p14, p13, p12, p11); //出力用ポート

BusOut mbedleds(LED4,LED3,LED2,LED1);

/* 赤外線センサに使うpinを配列に格納 */
PinName ir_num[ALL_IR] = {
         p19, 
         p20, 
         p25, 
         p26, 
         p27, 
         p28
};

DigitalIn sensor_ir(p30);

unsigned int moving_ave(unsigned int data)
{
    static unsigned int tmp[14] = {0};
    static unsigned int sum = 0;
    uint8_t i;
    uint8_t count;
    
    sum -= tmp[13];
    sum += data;
    tmp[13] = tmp[12];
    tmp[12] = tmp[11];
    tmp[11] = tmp[10];
    tmp[10] = tmp[9];
    tmp[9] = tmp[8];
    tmp[8] = tmp[7];
    tmp[7] = tmp[6];
    tmp[6] = tmp[5];
    tmp[5] = tmp[4];
    tmp[4] = tmp[3];
    tmp[3] = tmp[2];
    tmp[2] = tmp[1];
    tmp[1] = tmp[0];
    tmp[0] = data;
    
    return sum/10;
}

int main () {
    unsigned int active_ir = 0;     /* 今回更新する赤外線の番号 */
    unsigned int memory_ir = 0;         /*赤外線時間カウンタ*/
    unsigned int flag_ir = 0;
    
    for(;;){
        flag_ir = 1;
    
        //DigitalIn sensor_ir(ir_num[active_ir]); /* 今回更新する赤外線の個体を呼び出す */
        
        timer_ir.start();   /* タイマー起動 */
        
        if(sensor_ir){               /* もし立ち上がっていたら */
            while(sensor_ir){        /* 立ち下がるまで待つ */
                if(timer_ir.read_us() >= IR_TIME_NOTFOUND){
                    flag_ir = 0;
                    break;  /* 立ち上がっている時間が指定時間越えたらブレイク */
                }
            }
        }
        
        timer_ir.stop();    /* タイマー停止 */
        timer_ir.reset();   /* タイマーリセット */
        
        /*ボールが指定時間内に見つかっていたら*/
        if(flag_ir){
            timer_ir.start();   /* タイマー起動 */
            
            while(!(sensor_ir)){        /* 立ち上がるまで待つ */
                if(timer_ir.read_us() >= IR_TIME_NOTFOUND){
                    break;  /* 立ち上がっている時間が指定時間越えたらブレイク */
                }
            }
            
            memory_ir = timer_ir.read_us();
            
            while(1){          
            
                unsigned int counter_noise;
            
                if(!(sensor_ir)){
                    myleds = moving_ave( (timer_ir.read_us()-memory_ir)/10 ); /* パルス幅を記録 */
                    //ir_width[active_ir] = timer_ir.read_us()-memory_ir; /* パルス幅を記録 */
                    //myleds = (timer_ir.read_us()-memory_ir)/10; 
                    
                    myleds = 0xFF;
                    
                    pc.printf("%d\n",moving_ave( (timer_ir.read_us()-memory_ir)/10 ));
                    
                    wait(0.01);
                    break;
                }else{
                    /*ノイズ対策（ノイズで一瞬だけ立ち上がる可能性があるから）*/
                    //counter_noise = timer_ir.read_us();             /* 経過時間を保存 */
                    //while(timer_ir.read_us()-counter_noise <= 6){};   /* 6us間待つ */
                    //if(!(sensor_ir)){                               /* もし立ち下がっていたら */
                    //    flag_ir = 0; //iminasi
                        
                    //    timer_ir.stop();    /* タイマー停止 */
                    //    timer_ir.reset();   /* タイマーリセット */
                        
                    //    break;
                    //}
                }
            }
        }else{
            /*ボールが見つかっていない場合*/
            //ir_width[active_ir] = 0;
            myleds = 0x00; /* パルス幅を記録 */
        }
        timer_ir.stop();    /* タイマー停止 */
        timer_ir.reset();   /* タイマーリセット */
        
        memory_ir = 0;
        
        /*active_ir++;   次の赤外線センサへ（読み取る赤外線センサを順番に回す）
        if( active_ir >= NUM_IR ){
            active_ir = 0;       6個全ての赤外線センサをまわったら一番初めに戻る 
        }*/
    }
}
