/*YOZAKURAのアームコード
  シリアル通信で送るデータ S_Data={linearD[4],pitchD[4],yawD[4],ThermoD1[16],ThermoD2[16],CO2[4]} 計48bytes
  シリアル通信で受け取るデータ　R_Data=｛linear_ref[2bit],pitch_ref[2bit],yaw_ref[2bit]m,ode[2bit]} 計1byte
*/

#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled1(LED1); DigitalOut myled2(LED2); DigitalOut myled3(LED3); DigitalOut myled4(LED4);

struct ArmPacketBits {
                      unsigned int mode : 2;
                      unsigned int linear : 2;
                      unsigned int pitch : 2;
                      unsigned int yaw : 2;
                     };

union ArmPacket {
                 struct ArmPacketBits b;
                 unsigned char as_byte;
                };

/*--Dynamixel:begin-----------------------------------------------------------------------------------------*/
#include "AX12.h"
#include "MX28.h"

#define DYNA_DEBUG 0

DigitalOut low(p16); DigitalOut RelaySwitch(p18);

AX12 linear (p13, p14, 0, 1000000);      //直動Dynamixel
MX28 pitch (p13, p14, 1, 1000000);       //ピッチDynamixel
MX28 yaw (p13, p14, 2, 1000000);         //ヨーDynamixel

int linear_goal, pitch_goal, yaw_goal;

//最小値，最大値，角速度，初期値を指定[unit:degree]
//MX:MultiTurnモードでは-2520°～2520°(SetGoalの書き換え不要)
int linear_min = 100; int linear_MAX = 300; float linear_Speed=0.1; int linear_Init = linear_MAX;
int pitch_min = 172; int pitch_MAX = 334; float pitch_Speed=0.2; int pitch_Init = pitch_MAX;
int yaw_min = 360; int yaw_MAX = 360; float yaw_Speed=0.2; int yaw_Init = 0; //MultiTurnモード

void Dyna_init() {
    if(DYNA_DEBUG) printf("\nDyna_init\n");  
//    low = 0; RelaySwitch = 1;
    linear.SetTorqueLimit(0);
    pitch.SetTorqueLimit(0);
    yaw.SetTorqueLimit(0);
    linear.SetCWLimit(linear_min); linear.SetCCWLimit(linear_MAX); 
    linear.SetCRSpeed(linear_Speed); linear_goal=linear_Init;
    pitch.SetCWLimit(pitch_min); pitch.SetCCWLimit(pitch_MAX);
    pitch.SetCRSpeed(pitch_Speed); pitch_goal=pitch_Init;
    yaw.SetCWLimit(yaw_min); yaw.SetCCWLimit(yaw_MAX);
    yaw.SetCRSpeed(yaw_Speed); yaw_goal=yaw_Init;
    wait(1);
}

void Dyna_GetData(char* data) {
    if(DYNA_DEBUG) printf("\nDyna_SetData\n");
    float lP, lV, pP, pC, yP, yC;
    
    lP = linear.GetPosition(); lV = linear.GetVolts();
    pP = pitch.GetPosition(); pC = pitch.GetCurrent();
    yP = yaw.GetPosition(); yC = yaw.GetCurrent();
    
    linear_goal=lP; pitch_goal=pP; yaw_goal=yP; //現在角度を目標値に設定
    sprintf(data,"%4.1f %4.1f %4.1f %4.1f %4.1f %4.1f ",lP,pP,yP,lV,pC,yC);  
}

void Dyna_SetGoal(int linear_mode, int pitch_mode, int yaw_mode) {
    if(DYNA_DEBUG) printf("\nDyna_SetGoal\n");
    switch(linear_mode){
        case 0: break;
        case 1: linear.SetTorqueLimit(1); linear_goal-=10; break;
        case 2: linear.SetTorqueLimit(1); linear_goal+=20; break;
    }
    if(linear_mode!=0){
        if(linear_goal<linear_min) linear_goal=linear_min;
        if(linear_goal>linear_MAX) linear_goal=linear_MAX;
        linear.SetGoal(linear_goal);
    }
    
    switch(pitch_mode){
        case 0: break;
        case 1: pitch.SetTorqueLimit(1); pitch_goal-=10; break;
        case 2: pitch.SetTorqueLimit(1); pitch_goal+=10; break;
    }
    if(pitch_mode!=0){
        if(pitch_goal<pitch_min) pitch_goal=pitch_min;
        if(pitch_goal>pitch_MAX) pitch_goal=pitch_MAX; 
        pitch.SetGoal(pitch_goal);
    }
    
    switch(yaw_mode){
        case 0: break;
        case 1: yaw_goal-=10; break;
        case 2: yaw_goal+=10; break;
    }
    if(yaw_mode!=0){
        if(yaw_goal<-2520) yaw_goal=-2520;
        if(yaw_goal>2520) yaw_goal=2520; 
        yaw.SetGoal(yaw_goal);
    }
}

void Dyna_home_position() {
    if(DYNA_DEBUG) printf("\nDyna_home_position\n");
    linear.SetTorqueLimit(1);
    pitch.SetTorqueLimit(1);
    yaw.SetTorqueLimit(1);
    float lp;
    linear.SetGoal(linear_Init);
    lp=linear.GetPosition();
    if(lp > linear_MAX - 30) {  //ある程度縮んだら
        pitch.SetGoal(pitch_Init);
        yaw.SetGoal(yaw_Init);
    }
}

void Dyna_reset() {
    if(DYNA_DEBUG) printf("\nDyna_reset\n");
//    RelaySwitch = 0;
    linear.SetTorqueLimit(0);
    pitch.SetTorqueLimit(0);
    yaw.SetTorqueLimit(0);
    
    wait(1);
    
//    RelaySwitch = 1;
    linear.SetTorqueLimit(1);
    pitch.SetTorqueLimit(1);
    yaw.SetTorqueLimit(1);
}

void Dyna_end() {
    if(DYNA_DEBUG) printf("\nDyna_end\n");
//    RelaySwitch = 0;
    linear.SetTorqueLimit(0);
    pitch.SetTorqueLimit(0);
    yaw.SetTorqueLimit(0);
}
/*--Dynamixel:end-----------------------------------------------------------------------------------------*/


/*--Thermal_Sensor:begin----------------------------------------------------------------------------------*/
/*MEMS非接触温度センサ：形D6T-44L-06 4×4素子タイプ*/
/*データシート：http://www.omron.co.jp/ecb/products/sensor/special/mems/pdf/AN-D6T-01JP_r2.pdf*/

I2C MEMS1(p9, p10); // sda, scl
I2C MEMS2(p28, p27); // sda, scl

#define  D6T_addr  0x14
#define  D6T_cmd   0x4c

#define THERMO_DEBUG 0

char   I2C_rd1[64]; // 生データ
short  datr1[16]; // 16点 温度データ（10倍整数）
short  PTAT1; // センサ内部PTAT温度データ（10倍整数）
double dt1[16]; // 16点 温度データ
double dt1_temp[16];
short  d_PTAT1; // センサ内部PTAT温度データ

char   I2C_rd2[64]; // 生データ
short  datr2[16]; // 16点 温度データ（10倍整数）
short  PTAT2; // センサ内部PTAT温度データ（10倍整数）
double dt2[16]; // 16点 温度データ
double dt2_temp[16];
short  d_PTAT2; // センサ内部PTAT温度データ

void GetThermo(char* data) {
    char con[6];
    sprintf(data,"");
    
    /*MEMS1*/
    int  i,j;
    int  itemp;
    
    //// measure
    MEMS1.start();
    MEMS1.write(D6T_addr);
    MEMS1.write(D6T_cmd);
    // Repeated Start condition
    MEMS1.read(D6T_addr,I2C_rd1,35);
//        if(check_PEC(I2C_rd) == -1) continue; // error
    for(i=0,j=0;i<17;i++){
        itemp = (I2C_rd1[j++] & 0xff);
        itemp += I2C_rd1[j++] * 256;
        if(i == 0) PTAT1 = itemp;
        else datr1[i-1] = itemp;
    }
    for(i=0;i<16;i++){
        dt1[i] = 0.1 * datr1[i];
    }
    for(int i=0;i<16;i++){
        if(dt1[i]<50 && dt1[i]>5) {
            sprintf(con,"%3.1f ",dt1[i]);
            dt1_temp[i]=dt1[i];
        }
        else sprintf(con,"%3.1f ",dt1_temp[i]);
        strcat(data,con);
    }
    if(THERMO_DEBUG){
        printf("\nThermal_Sensor 1");
        for(i=0;i<16;i++){
            if(i%4==0) printf("\n");
            printf("%3.1f ",dt1[i]);
        } printf("\n");
    }
    d_PTAT1 = 0.1 * PTAT1;
//    wait(0.1);
    /*MEMS1*/
        
    /*MEMS2*/  
    //// measure
    MEMS2.start();
    MEMS2.write(D6T_addr);
    MEMS2.write(D6T_cmd);
    // Repeated Start condition
    MEMS2.read(D6T_addr,I2C_rd2,35);
//        if(check_PEC(I2C_rd) == -1) continue; // error
    for(i=0,j=0;i<17;i++){
        itemp = (I2C_rd2[j++] & 0xff);
        itemp += I2C_rd2[j++] * 256;
        if(i == 0) PTAT2 = itemp;
        else datr2[i-1] = itemp;
    }
    for(i=0;i<16;i++){
        dt2[i] = 0.1 * datr2[i];
    }
    for(int i=0;i<16;i++){
        if(dt2[i]<50 && dt2[i]>5) {
            sprintf(con,"%3.1f ",dt2[i]);
            dt2_temp[i]=dt2[i];
        }
        else sprintf(con,"%3.1f ",dt2_temp[i]);
        strcat(data,con);
    }
    if(THERMO_DEBUG){
        printf("\nThermal_Sensor 2");
        for(i=0;i<16;i++){
            if(i%4==0) printf("\n");
            printf("%3.1f ",dt2[i]);
        } printf("\n");
    }
    d_PTAT2 = 0.1 * PTAT2;
//    wait(0.1);
    /*MEMS2*/
}
/*--Thermal_Sensor:end------------------------------------------------------------------------------------*/

/*--CO2_Sensor:begin--------------------------------------------------------------------------------------*/
/*CO2センサモジュール：A051020-AQ6B-01*/
/*データシート：http://www.fisinc.co.jp/common/pdf/A051020-AQ6.pdf*/
/*参考 外気:396.0[ppm](2013年) 呼気:13,200[ppm] ※このセンサで測れるのは3000[ppm]まで*/
#include "mbed.h"

AnalogIn ain(p17);

#define CO2_DEBUG 0

float GetCO2() {
    float v; //生データ：電圧
    float sensor_v,CO2;
    
    v = ain.read()*3.3;
    sensor_v = v * 5.0/3.3; //電圧レベルを合わせる
    CO2 = sensor_v * 1000 + 400;  //データシートより
    
    if(CO2_DEBUG) printf("\nCO2:%4.1f\n",CO2);

    return(CO2);
}
/*--CO2_Sensor:end----------------------------------------------------------------------------------------*/


/*---------------
    MAIN LOOP
----------------*/
#define DEBUG 0

int main() {
    myled1=1; myled2=1; myled3=1; myled4=1;
    pc.baud(38400);
    
    char Dyna_data[50];
    char Thermo_data[200];
    float CO2_data; 
    
    myled1=1; myled2=1; myled3=0; myled4=0;
    Dyna_init();
//    Dyna_home_position();
//    wait(2);
//    Dyna_home_position();
//    wait(2);
    myled1=0; myled2=0; myled3=1; myled4=0;
    
    union ArmPacket Read_data;
        
    char Send_data[250];
    //int Read_data;
    int Joy_mode, linear_mode, pitch_mode, yaw_mode;
    
    while(1) {
        //Read_data=pc.getc();
        Read_data.as_byte=pc.getc();
        wait_ms(1);
        if(Read_data.as_byte == 7) {printf("arm\n"); continue;}
        //Joy_mode = Read_data & 0x03; //ジョイスティックのモード判定
        Joy_mode = Read_data.b.mode; //ジョイスティックのモード判定
        if(DEBUG) printf("Joy_mode : %d\n",Joy_mode);

        switch(Joy_mode){
            case 0: //通常モード
                myled1=0; myled2=0; myled3=0; myled4=0;
            /*--Dynamixel:begin---------------------------------------------------------------*/       
                //Dynamixelへの命令を判定
                //linear_mode = Read_data & 0xc0; linear_mode = linear_mode >> 6; if(DEBUG) printf("linear_mode : %d\n",linear_mode);
//                pitch_mode = Read_data & 0x30; pitch_mode = pitch_mode >> 4; if(DEBUG) printf("pitch_mode : %d\n",pitch_mode);
//                yaw_mode = Read_data & 0x0c; yaw_mode = yaw_mode >> 2; if(DEBUG) printf("yaw_mode : %d\n",yaw_mode);
                linear_mode = Read_data.b.linear;
                pitch_mode = Read_data.b.pitch;
                yaw_mode = Read_data.b.yaw;
                
                //目標角度を変更
                myled2=1;
                Dyna_SetGoal(linear_mode, pitch_mode, yaw_mode);
                myled2=0;
            /*--Dynamixel:end------------------------------------------------------------------*/            
                break;
            
            case 1: //ホームポジション
                myled1=1; myled2=0; myled3=0; myled4=1; Dyna_home_position(); break;
                
            case 2: //リセット
                myled1=0; myled2=1; myled3=1; myled4=0; Dyna_reset(); break;
            
            case 3: //終了
                myled1=1; myled2=1; myled3=1; myled4=1; Dyna_end(); break;
        }

            /*--Thermal_Sensor:begin-----------------------------------------------------------*/
                //値を取得
                myled3=1;
                GetThermo(Thermo_data);
            /*--Thermal_Sensor:end-------------------------------------------------------------*/
        
            /*--CO2_Sensor:begin---------------------------------------------------------------*/
                //値を取得
                CO2_data=GetCO2();
                myled3=0;
            /*--CO2_Sensor:end-----------------------------------------------------------------*/
                
                //現在の角度・電圧・電流を取得
                myled1=1;
                Dyna_GetData(Dyna_data);
                myled1=0;            
            
            //値を送信
                myled4=1;
                sprintf(Send_data,"%s%s%4.1f",Dyna_data,Thermo_data,CO2_data);
                pc.printf("%s\n",Send_data);
                myled4=0;      
    }
}

/* CoolTermのSend stringを使う場合 Hex : 16進数で値を送信可能 なので
    home_position 40
    reset         80
    end           c0
*/