/*YOZAKURAのアームコード
  シリアル通信で送るデータ S_Data={linearD[4],pitchD[4],yawD[4],ThermoD1[16],ThermoD2[16],CO2[4]} 計48bytes
  シリアル通信で受け取るデータ　R_Data=｛mode[2bit],linear_ref[2bit],pitch_ref[2bit],yaw_ref[2bit]} 計1byte
*/

#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled1(LED1); DigitalOut myled2(LED2); DigitalOut myled3(LED3); DigitalOut myled4(LED4);

/*--Dynamixel:begin-----------------------------------------------------------------------------------------*/
#include "AX12.h"
#include "MX28.h"

DigitalOut low(p16); DigitalOut RelaySwitch(p18);

AX12 linear (p13, p14, 0, 1000000);      //直動Dynamixel
MX28 pitch (p13, p14, 1, 1000000);       //ピッチDynamixel
MX28 yaw (p13, p14, 2, 1000000);         //ヨーDynamixel

int linear_goal, pitch_goal, yaw_goal;

//最小値，最大値，角速度，初期値を指定[unit:degree]
//MX:MultiTurnモードでは-2520°～2520°(SetGoalの書き換え不要)
int linear_min = 100; int linear_MAX = 300; float linear_Speed=0.1; int linear_Init = linear_MAX;
int pitch_min = 172; int pitch_MAX = 334; float pitch_Speed=0.2; int pitch_Init = pitch_MAX;
int yaw_min = 360; int yaw_MAX = 360; float yaw_Speed=0.2; int yaw_Init = 0; //MultiTurnモード

void Dyna_init() {
    low = 0; RelaySwitch = 1;
    printf("linear_Init\n");
    linear.SetCWLimit(linear_min); linear.SetCCWLimit(linear_MAX); 
    linear.SetCRSpeed(linear_Speed); linear_goal=linear_Init; linear.SetGoal(linear_Init);
    printf("pitch_Init\n");
    pitch.SetCWLimit(pitch_min); pitch.SetCCWLimit(pitch_MAX); 
    pitch.SetCRSpeed(pitch_Speed); pitch_goal=pitch_Init; pitch.SetGoal(pitch_Init);
    printf("yaw_Init\n");
    yaw.SetCWLimit(yaw_min); yaw.SetCCWLimit(yaw_MAX); 
    yaw.SetCRSpeed(yaw_Speed); yaw_goal=yaw_Init; yaw.SetGoal(yaw_Init);
    wait(1);
}

void Dyna_GetData(char* data) {
    float lP, lV, pP, pC, yP, yC;
    
    lP = linear.GetPosition(); lV = linear.GetVolts();
    pP = pitch.GetPosition(); pC = pitch.GetCurrent();
    yP = yaw.GetPosition(); yC = yaw.GetCurrent();
    
    linear_goal=lP; pitch_goal=pP; yaw_goal=yP; //現在角度を目標値に設定
    printf("\nlinearPosition : %4.1f[degree]\n",lP); printf("Voltage : %4.1f[V]\n",lV);
    printf("pitchPosition : %4.1f[degree]\n",pP); printf("pitchCurrent : %4.1f[mA]\n",pC);
    printf("yawPosition : %4.1f[degree]\n",yP); printf("yawCurrent : %4.1f[mA]\n",yC);
    sprintf(data,"%4.1f %4.1f %4.1f %4.1f %4.1f %4.1f ",lP,lV,pP,pC,yP,yC); 
}

void Dyna_SetGoal(int linear_mode, int pitch_mode, int yaw_mode) {
    switch(linear_mode){
        case 29: break;
        case 30: linear.SetTorqueLimit(1); linear_goal-=2; break;
        case 31: linear.SetTorqueLimit(1); linear_goal+=2; break;
    }
    if(linear_goal>linear_MAX) linear_goal=linear_MAX; 
    if(linear_goal<linear_min) linear_goal=linear_min;
    linear.SetGoal(linear_goal);
    
    switch(pitch_mode){
        case 29: break;
        case 30: pitch_goal-=3; 
                 if(pitch_goal>pitch_MAX) pitch_goal=pitch_MAX;
                 break;
        case 31: pitch_goal+=3; 
                 if(pitch_goal<pitch_min) pitch_goal=pitch_min;
                 break;
    }    
    if(pitch_goal>pitch_MAX) pitch_goal=pitch_MAX; 
    if(pitch_goal<pitch_min) pitch_goal=pitch_min;
    pitch.SetGoal(pitch_goal);
    
    switch(yaw_mode){
        case 29: break;
        case 30: yaw_goal-=3; break;
        case 31: yaw_goal+=3; break;
    }
    if(pitch_goal>2520) pitch_goal=2520; 
    if(pitch_goal<-2520) pitch_goal=-2520;
    yaw.SetGoal(yaw_goal);
}
/*--Dynamixel:end-----------------------------------------------------------------------------------------*/


/*--Thermal_Sensor:begin----------------------------------------------------------------------------------*/
/*MEMS非接触温度センサ：形D6T-44L-06 4×4素子タイプ*/
/*データシート：http://www.omron.co.jp/ecb/products/sensor/special/mems/pdf/AN-D6T-01JP_r2.pdf*/

I2C MEMS1(p9, p10); // sda, scl
I2C MEMS2(p28, p27); // sda, scl

#define  D6T_addr  0x14
#define  D6T_cmd   0x4c

#define THERMO_DEBUG 1

char   I2C_rd1[64]; // 生データ
short  datr1[16]; // 16点 温度データ（10倍整数）
short  PTAT1; // センサ内部PTAT温度データ（10倍整数）
double dt1[16]; // 16点 温度データ
double dt1_temp[16];
short  d_PTAT1; // センサ内部PTAT温度データ

char   I2C_rd2[64]; // 生データ
short  datr2[16]; // 16点 温度データ（10倍整数）
short  PTAT2; // センサ内部PTAT温度データ（10倍整数）
double dt2[16]; // 16点 温度データ
double dt2_temp[16];
short  d_PTAT2; // センサ内部PTAT温度データ

void GetThermo(char* data) {
    char con[6];
    sprintf(data,"");
    
    /*MEMS1*/
    int  i,j;
    int  itemp;
    
    //// measure
    MEMS1.start();
    MEMS1.write(D6T_addr);
    MEMS1.write(D6T_cmd);
    // Repeated Start condition
    MEMS1.read(D6T_addr,I2C_rd1,35);
//        if(check_PEC(I2C_rd) == -1) continue; // error
    for(i=0,j=0;i<17;i++){
        itemp = (I2C_rd1[j++] & 0xff);
        itemp += I2C_rd1[j++] * 256;
        if(i == 0) PTAT1 = itemp;
        else datr1[i-1] = itemp;
    }
    for(i=0;i<16;i++){
        dt1[i] = 0.1 * datr1[i];
    }
    for(int i=0;i<16;i++){
        if(dt1[i]<50 && dt1[i]>5) {
            sprintf(con,"%3.1f ",dt1[i]);
            dt1_temp[i]=dt1[i];
        }
        else sprintf(con,"%3.1f ",dt1_temp[i]);
        strcat(data,con);
    }
    if(THERMO_DEBUG){
        printf("\nThermal_Sensor 1");
        for(i=0;i<16;i++){
            if(i%4==0) printf("\n");
            printf("%3.1f ",dt1[i]);
        } printf("\n");
    }
    d_PTAT1 = 0.1 * PTAT1;
    wait(0.1);
    /*MEMS1*/
        
    /*MEMS2*/  
    //// measure
    MEMS2.start();
    MEMS2.write(D6T_addr);
    MEMS2.write(D6T_cmd);
    // Repeated Start condition
    MEMS2.read(D6T_addr,I2C_rd2,35);
//        if(check_PEC(I2C_rd) == -1) continue; // error
    for(i=0,j=0;i<17;i++){
        itemp = (I2C_rd2[j++] & 0xff);
        itemp += I2C_rd2[j++] * 256;
        if(i == 0) PTAT2 = itemp;
        else datr2[i-1] = itemp;
    }
    for(i=0;i<16;i++){
        dt2[i] = 0.1 * datr2[i];
    }
    for(int i=0;i<16;i++){
        if(dt1[i]<50 && dt1[i]>5) {
            sprintf(con,"%3.1f ",dt2[i]);
            dt2_temp[i]=dt2[i];
        }
        else sprintf(con,"%3.1f ",dt2_temp[i]);
        strcat(data,con);
    }
    if(THERMO_DEBUG){
        printf("\nThermal_Sensor 2");
        for(i=0;i<16;i++){
            if(i%4==0) printf("\n");
            printf("%3.1f ",dt2[i]);
        } printf("\n");
    }
    d_PTAT2 = 0.1 * PTAT2;
    wait(0.1);
    /*MEMS2*/
}
/*--Thermal_Sensor:end------------------------------------------------------------------------------------*/


/*--CO2_Sensor:begin--------------------------------------------------------------------------------------*/
/*CO2センサモジュール：A051020-AQ6B-01*/
/*データシート：http://www.fisinc.co.jp/common/pdf/A051020-AQ6.pdf*/
/*参考 外気:396.0[ppm](2013年) 呼気:13,200[ppm] ※このセンサで測れるのは3000[ppm]まで*/
#include "mbed.h"

AnalogIn ain(p20);

#define CO2_DEBUG 1

float GetCO2() {
    float v; //生データ：電圧
    float sensor_v,CO2;
    
    v = ain.read()*3.3;
    sensor_v = v * 5.0/3.3; //電圧レベルを合わせる
    CO2 = sensor_v * 1000 + 400;  //データシートより
    
    if(CO2_DEBUG) printf("\nCO2:%4.1f\n",CO2);

    return(CO2);
}
/*--CO2_Sensor:end----------------------------------------------------------------------------------------*/


/*---------------
    MAIN ROOP
----------------*/
int main() {
    char Dyna_data[50];
    char Thermo_data[200];
    float CO2_data;
    
    Dyna_init();
    
    char Send_data[250];
    int Read_data;
    int Joy_mode, linear_mode, pitch_mode, yaw_mode;
    
    while(1) {

        /*--Dynamixel:begin---------------------------------------------------------------*/       
//                //Dynamixelへの命令を判定
//                linear_mode = R_data & 0x0c; linear_mode = linear_mode >> 2;
//                pitch_mode = R_data & 0x30; pitch_mode = pitch_mode >> 4;
//                yaw_mode = R_data & 0xc0; yaw_mode = yaw_mode >> 6;                

            //現在の角度・電圧・電流を取得
            myled1=1;
            Dyna_GetData(Dyna_data);
            myled1=0;
        
            printf("linear_mode : ");
            linear_mode=pc.getc();
            printf("%d\n",linear_mode);
            printf("pitch_mode : ");
            pitch_mode=pc.getc();
            printf("%d\n",pitch_mode);
            printf("yaw_mode : ");
            yaw_mode=pc.getc();
            printf("%d\n",yaw_mode);
        
            //目標角度を変更
            myled2=1;
            Dyna_SetGoal(linear_mode, pitch_mode, yaw_mode);
            myled2=0;
        /*--Dynamixel:end------------------------------------------------------------------*/       
    
        /*--Thermal_Sensor:begin-----------------------------------------------------------*/
            //値を取得
            myled3=1;
            GetThermo(Thermo_data);
        /*--Thermal_Sensor:end-------------------------------------------------------------*/
    
        /*--CO2_Sensor:begin---------------------------------------------------------------*/
            //値＝””
            CO2_data=GetCO2();
            myled3=0;
        /*--CO2_Sensor:end-----------------------------------------------------------------*/
        
        //値を送信
            myled4=1;
            printf("\nDyna_data : %s\n",Dyna_data); printf("Thermo_data : %s\n",Thermo_data);
            sprintf(Send_data,"%s%s%4.1f",Dyna_data,Thermo_data,CO2_data);
            printf("Send_data : %s\n",Send_data);
            myled4=0;           

    }
}