#include "mbed.h"
#include "vm.h"
#include "compile.h"
#include "interpret.h"

BusOut leds(LED1, LED2, LED3, LED4);
Serial pc(USBTX, USBRX); // tx, rx

void callback(struct Context *context) {
    struct stack *stack = context->rhs;
    struct variable *f = (struct variable*)stack_pop(stack);
    const char *fstr = byte_array_to_string(f->str);
    struct variable *v = (struct variable*)stack_pop(stack);

    if (!strcmp(fstr, "blink")) {
        pc.printf("blink %d\n\r", v->integer);
        leds = 1 << v->integer;
    } else if (!strcmp(fstr, "wait")) {
        pc.printf("wait %.1f\n\r", v->floater);
        wait(v->floater);
    }
}

int main() {
    const char *fg = "b = 0 while b<40 vm.yield('blink',b%4) b = b+1 vm.yield('wait',0.5) end";
    interpret_string(fg, &callback);
}