#include "mbed.h"
#include "platform/mbed_thread.h"
#include "Controller.h"

#define INT_TIME 0.001
#define INT_TIME_MS INT_TIME*1000


RawSerial sabertooth1(p21,NC,115200);//左前　出力
RawSerial sabertooth1(p23,NC,115200);//左後　出力
RawSerial sabertooth2(p24,NC,115200);//右後　出力
RawSerial sabertooth2(p22,NC,115200);//右前　出力
DigitalOut air(p25);//エアシリンダーのつもり

Serial pc(USBTX, USBRX,115200);
Controller con(p9,p10,115200); //TXpin, RXpin, baudrateを設定
//Controller con(p13,p14,115200); //TXpin, RXpin, baudrateを設定
//DigitalOut led_user(LED_USER);
//DigitalOut led_red(LED_RED);
//DigitalOut pin_emergency(D0); //非常停止信号

Ticker interrupt;
bool flag_10ms = false;
bool flag_1s = false;

void interrupt_func()
{
    static int count_10ms = 0;
    if(count_10ms++ > (INT_TIME_MS*10 - 1))
    {
        flag_10ms = true;
        count_10ms = 0;
        
        static int count_1s = 0;
        if(count_1s++ > (INT_TIME_MS*100 -1))
        {
            flag_1s = true;
            count_1s = 0;
        }
    }
}

int main()
{   
    //pc.baud(115200);
    
    /* 第一引数はタイムアウト時間[ms]，第二引数はupdate関数の呼び出し周期[ms] */
    con.init(1000, INT_TIME_MS*10); //init関数を呼び出さなければタイムアウトの処理は行われない（available関数は常にtrueを返す）
    
    interrupt.attach(&interrupt_func, INT_TIME);
    
    while(1) 
    {
        //pc.printf("");
        if(flag_10ms)
        {
            con.update(); //main関数のflag内で呼び出す．
            if(con.available())
            {
                int buttonState = con.getButtonState();
                uint8_t joyRy = con.readJoyRYbyte();
                uint8_t joyLx = con.readJoyLXbyte();
                uint8_t joyLy = con.readJoyLYbyte();
                
                pc.printf("%u\t", buttonState);
                pc.printf("%u\t", joyRy);
                pc.printf("%u\t", joyLx);
                pc.printf("%u\r", joyLy);
                
                switch(buttonState)
                {
                    case 8:
                        air.write(1);
                        break;
                    default:
                        air.write(0);
                        break;
                }
                
                double LF=0;
                double RF=0;
                double LB=0;
                double RB=0;
                
                LF=joyLx-joyLy-joyRy+128;//上と左が正　下と右が負 Yがスティック左右方向　Xがスティック上下方向
                RF=-joyLx-joyLy-joyRy+384;
                LB=joyLx+joyLy-joyRy-128;
                RB=-joyLx+joyLy-joyRy+128;
                
                sabertooth1.printf("M1:%d\r\n",LF);
                sabertooth1.printf("M2:%d\r\n",LB);
                sabertooth2.printf("M1:%d\r\n",RB);
                sabertooth2.printf("M2:%d\r\n",RF);
                
                pc.printf("%lf\t", LF);
                pc.printf("%lf\t", RF);
                pc.printf("%lf\t", LB);
                pc.printf("%lf\r\n", RB);
                //led_red.write(1);
                //pin_emergency.write(1); //非常停止を解除する
            }
            else
            {
                pc.printf("disconnected\r\n");
                //led_red.write(0);
                //pin_emergency.write(0); //非常停止を作動させる
            }
            
            flag_10ms = false;
        }
        
        if(flag_1s)
        {
            //led_user.write(!led_user.read());
            flag_1s = false;
        }
        wait_us(1);
        //thread_sleep_for(1);
    }
}
