/*
 *https://os.mbed.com/users/kikuchi8810/code/controllerForMbed_test//file/ab1c94d6f4fb/main.cpp/
 *元データ
 *作：菊池
 */



#ifndef CONTROLLER_H
#define CONTROLLER_H
 
#include "mbed.h"
#include "RawSerial.h"
#include "define.h"
 
struct ControllerData{
    unsigned int ButtonState;
    uint8_t RJoyX, RJoyY, LJoyX, LJoyY;
};
 
class Controller{
    public:
        Controller(PinName tx, PinName rx, int baudrate);
        int count_ms, pre_count_ms; //受信時刻と前回の受信時刻
 
        bool readButton_bin(unsigned int ButtonNum); //押していない時はfalse(0),押してるときはtrue(1)を返す．　ButtonNumはデータの欲しいボタンの名前を
        int  readButton(unsigned int ButtonNum);     //上にプラスして 押した瞬間は2，放した瞬間は-1を返す．    define.hを参考に数字を入力しても良い
        bool getComCheck(void); //値が更新されたときにtrueを返す．
        bool update(); //受信の処理＋ボタンの情報の更新．受信割込みで処理
        bool clearBuffer(void);//buffer消去用．falseが返ってくれば消去完了.
        bool rate(void);//送信側で入力がある場合にtrue.
        
        void init(int _time_out_ms, int _int_time_ms); //コントローラの通信速度と通信のタイムアウト時間を設定
        bool available(void);
 
        unsigned int getButtonState();  //分解する前のButtonStateの情報をprint 0~255の値をとる
        void clearButtonState();
        ControllerData getConData();
        unsigned int getButtonFlagRise();
        unsigned int getButtonFlagFall();
    
                                //       X
        double readJoyRX();     //       ^ 
        double readJoyRY();     //       | 
        double readJoyLX();     //  Y<---+----
        double readJoyLY();     //       | 
                                //       | 
                                //  1.0  ~   -1.0
 
                                   //       X
        uint8_t readJoyRXbyte();   //       ^ 
        uint8_t readJoyRYbyte();   //       |
        uint8_t readJoyLXbyte();   //  Y<---+----
        uint8_t readJoyLYbyte();   //       | 
                                   //       |
                                   //  255  ~    0
 
    private:
        
        RawSerial serial;
        //Timer timer;
 
        bool comCheck;
        ControllerData conData;
        ControllerData pre_conData;
        unsigned int lastButtonState;
 
        int time_out_ms;
        double int_time_ms;
        bool conAvailable;
 
        uint8_t serial_recieve(){
            char temp;
            do{
                temp = serial.getc();
            }
            while(temp==-1);
            //CONTROL.write(temp);    //受け取ったデータをTXピンからそのまま送っている．他のマイコンにも流したいとき用．
            return temp;
        }
};
 
#endif