#ifndef HorizontalController_h
#define HorizontalController_h
#include "mbed.h"
#include "Library.h"
// Horizontal controller class
class HorizontalController
{
    public :
        // Class constructor
        HorizontalController () ;
        // Control reference roll and pitch angles given reference horizontal positions and current horizontal positions and velocities
        void control ( float x_r , float y_r , float x, float y, float u, float v);
        // Reference roll and pitch angles ( rad)
        float phi_r , theta_r ;
    private :
        // Control acceleration given reference position and current position and velocity with given controller gains
        float control_single ( float pos_r , float pos , float vel , float kp_hori , float kd_hori);
        // Last horizontal positions error (m)
        float x_e_last , y_e_last ;
        float pos_e_last;
};
# endif