#ifndef AttitudeController_h
#define AttitudeController_h

#include "mbed.h"
#include "Library.h"

class AttitudeController
{
    public :
        // Class constructor
        AttitudeController () ;
        // Control torques given reference angles and current angles and angular velocities
            void control(float phi_r, float theta_r, float psi_r, float phi, float theta, float psi);
        // Torques (N.m)
        float tau_phi, tau_theta, tau_psi;
        
    private :
    // Control torque of a single axis given reference angles and current angles and angular velocities ( with given gains and /or time constants and moments of inertia )
        float single_axis_control(float angle_r, float angle, float K_angle, float K_rate , float I, float last_erro_angle);
        
        float last_erro_phi, last_erro_theta, last_erro_psi;
        
        float last_erro;
};
# endif

