#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include <string>
#include <vector>
#include <algorithm>
#include <sstream>
#include <iomanip>


// AppEUI
static uint8_t AppEUI[8]={0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88};
// AppKey
static uint8_t AppKey[16]={0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88};

// AppEUI
//static uint8_t AppEUI[8]={0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x01, 0x07, 0xDF};
// AppKey
//static uint8_t AppKey[16]={0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11};

static uint8_t config_frequency_sub_band = 3;


InterruptIn pulseInterrupt(PC_13);
DigitalOut greenLed(LED1); // To turn the join LED on/off

int pulseCount;
int IRQ;

void highPulseDetected() {    
    IRQ=1;
}

void no_highPulseDetected() {
    IRQ = 0;    
}

mDot* dot;

int main() {
    
    Serial pc(USBTX, USBRX);
    // Set up the network
    
    pc.baud(115200);
    pc.printf("TTN OTAA mDot LoRa Raingauge sensor\n\r");
    
    greenLed = 1; // LED is ON
    wait_ms(2000); // 200 ms
    greenLed = 0;
    
    int32_t ret;
    
    std::ostringstream ss;
    
    std::vector<uint8_t> nwkId;
    std::vector<uint8_t> nwkKey;

    // get a mDot handle
    dot = mDot::getInstance();
    
    // print library version information
    logInfo("Version: %s", dot->getId().c_str());

    // reset to default config so we know what state we're in
    dot->resetConfig();
    
    dot->setJoinByteOrder(mDot::LSB);
    
    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);
    
    //joinmode: [MANUAL = ABP]/[OTA]/[AUTO_OTA]
    dot->setJoinMode(mDot::AUTO_OTA);
        
    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()
    
    // frequency sub band is only applicable in the 915 (US) frequency band
    logInfo("Setting frequency sub band");
    if ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
        logError("Failed to set frequency sub band %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    std::vector<uint8_t> temp;    

    if ((ret = dot->setPublicNetwork(true)) != mDot::MDOT_OK) {
        logError("Failed to enable public network %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    uint8_t *it = AppEUI;
    for (uint8_t i = 0; i<8; i++)
        nwkId.push_back((uint8_t) *it++);
    
    it = AppKey;
    for (uint8_t i = 0; i<16; i++)
        nwkKey.push_back((uint8_t) *it++);
    
    logInfo("Set Network Id");
    if ((ret = dot->setNetworkId(nwkId)) != mDot::MDOT_OK) {
        logError("Failed to set Network Id %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    logInfo("Set Network Key");
    if ((ret = dot->setNetworkKey(nwkKey)) != mDot::MDOT_OK) {
        logError("Failed to set Network Id %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }    
   
    // a higher spreading factor allows for longer range but lower throughput
    // in the 915 (US) frequency band, spreading factors 7 - 10 are available
    // in the 868 (EU) frequency band, spreading factors 7 - 12 are available
    logInfo("Setting TX spreading factor");
    if ((ret = dot->setTxDataRate(mDot::SF_10)) != mDot::MDOT_OK) {
        logError("Failed to set TX datarate %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    // Set configured gain of installed antenna
    logInfo("Setting Antenna Gain");
    if ((ret = dot->setAntennaGain(5)) != mDot::MDOT_OK){
        logError("Failed to set Antenna Gain %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    // request receive confirmation of packets from the gateway
    logInfo("Disabling ACKs");
    if ((ret = dot->setAck(0)) != mDot::MDOT_OK) {
        logError("Failed to enable ACKs %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    // save this configuration to the mDot's NVM
    logInfo("Saving config");
    if (! dot->saveConfig()) {
        logError("Failed to save configuration");
    }
    
    logInfo("Joining Network");

    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
        logError("failed to join network [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
        wait_ms(dot->getNextTxMs() + 1);
    }

    logInfo("Joined Network");
    
    pulseCount=0; 
    pulseInterrupt.rise(&highPulseDetected);
    pulseInterrupt.fall(&no_highPulseDetected);
    IRQ=0;
    
    // Message you want to send
    std::string data_str = "Hello!"; 
    
    set_time(1476612300); 
    
    time_t start = time(NULL);
    time_t end = time(NULL);
    int cost; 
    
    printf("bbbbbbbbbbbbbegin to collect data.\n\r");
    time(&start);
    
    // Start the loop
    while (true) {
                
        time_t seconds = time(NULL);
        //pc.printf("1. Start Time as a basic string = %s", ctime(&start)); 
        //pc.printf("^^^^^^^^^^^^^^^^^^^^begin to sleep^^^^^^^^^^^^^^^^^^^^Sleep Time = %s", ctime(&seconds));
        
        // Send the MDot to sleep.
        dot->sleep(600, mDot::RTC_ALARM_OR_INTERRUPT, false);   //////////////////////////////60,3600*24
        time(&end);                   
        //pc.printf("^^^^^^^^^^^^^^^^^^^^wake up^^^^^^^^^^^^^^^^^^^^Wakeup Time = %s", ctime(&end));
        wait_ms(100);
                
        if(IRQ==1){
            IRQ=0;
            pulseCount = pulseCount + 1;
            //pc.printf("2.data = %d\n\r", pulseCount);          
        }
        
        cost=(int)difftime(end,start);  
                
        //send data every 5000ms           
        //pc.printf("5.cost = %d\n\r", cost);   
        if(cost >= 600) {           /////////////////////600s = 10min
            //pc.printf("3. finish collecting data.\n\r");
            //printf("++++++++++++++++++Collecting data takes %d s++++++++++++++++++++\n\r", cost);
            time_t seconds = time(NULL);
            //pc.printf("4.Finishing Time as a basic string = %s", ctime(&seconds));
            if(pulseCount == 0){
                pulseCount = pulseCount;
            } else {
                pulseCount = pulseCount;
            }
            
            //pc.printf("pulseCount = %d in 5 seconds.\n\r", pulseCount);
            
            // Copy the message in an array of bytes
            std::vector<uint8_t> data;
            ss.str("");    
            data.clear();    
            ss << pulseCount;
            data_str = "12," + ss.str(); 
                   
            for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++)
                data.push_back((uint8_t) *it);
            // Send the data
             if ((ret = dot->send(data)) != mDot::MDOT_OK) {
                // Oops, there was an error, check the debug screen
                logError("Failed to send", ret, mDot::getReturnCodeString(ret).c_str());
            } else {
                // Sent the data
                logInfo("Successfully sent data");
            }            
            
            if ((ret = dot->send(data)) != mDot::MDOT_OK) {
                // Oops, there was an error, check the debug screen
                logError("Failed to send", ret, mDot::getReturnCodeString(ret).c_str());
            } else {
                // Sent the data
                logInfo("Successfully sent data2");
            }   
            
            if ((ret = dot->send(data)) != mDot::MDOT_OK) {
                // Oops, there was an error, check the debug screen
                logError("Failed to send", ret, mDot::getReturnCodeString(ret).c_str());
            } else {
                // Sent the data
                logInfo("Successfully sent data3");
            }   
                        
            IRQ=0;
            pulseCount = 0;

            //pc.printf("begin to collect data\n\r"); 
            set_time(1476612300); 
        }

        
    }//end while

    return 0;
}