#include "mbed.h"

DigitalOut myled(LED1);
DigitalOut resetimu(p11);
Serial pc(USBTX, USBRX); // tx, rx
Serial r1350n(p9, p10);  // tx, rx


char buf[] = "Hello World!";
int state = 0 , counter = 0;
unsigned char  buffer[15];
 
void dev_rx () {
    unsigned char data;
    data = r1350n.getc();
    switch (state) {
    case 0:
      if (data == 0xaa) {
        state++;
      }
      break;
    case 1:
      if (data == 0x00) {
        state++;
      } 
      else {
        counter = 0;
        state = 0;
      }
      break;
    case 2:
      buffer[counter++] = data;
      if (counter >= 13) {
        int sum = 0;
        for (int i = 0; i < 11; i++) sum += buffer[i];
        if ((sum & 0xff) == buffer[12]) {
          pc.printf("Angle = %4d,AccX = %4d,AccY = %4d,AccZ = %4d\r\n",
            (buffer[2] << 8) | buffer[1],
            (buffer[6] << 8) | buffer[5],
            (buffer[8] << 8) | buffer[7],
            (buffer[10] << 8) | buffer[9]
            );
          wait(0.01);
          //Serial.flush();
        }
        state = 0;
        counter = 0;
      }
      break;
    }
}
 
int main() {
    r1350n.baud(115200);
    resetimu = 0;
    wait(0.1);
    resetimu = 1;
    wait(2);
    //pc.attach(pc_rx, Serial::RxIrq);
    pc.printf("Hello World!\n");
    r1350n.attach(dev_rx, Serial::RxIrq);
    //pc.attach(pc_tx, Serial::TxIrq);
 
    while(1){
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}