#include "mbed.h"
#include "main.h"
#include "cmsis_os.h"
#include "communication.h"
#include "ADE7912.h"
#include "stdlib.h"
#include "EthernetInterface.h"
#include "LWIPStack.h"
#include "dma.h"
#include "spi.h"
#include "gpio.h"

EthernetInterface net;

DigitalOut led1(LED1);
Thread thread;
int out_buffer[2];

uint32_t bufFR = 0xAA;
uint8_t str4byte[3]; 


void UDP_thread()
{
    printf("UDP Socket example\n");
    net.set_network(SocketAddress("192.168.0.10"), SocketAddress("255.255.255.0"), SocketAddress("192.168.0.1"));
    if (0 != net.connect()) {
        printf("Error connecting\n");
    }

    UDPSocket sock;
    sock.open(&net);
    sock.bind(55151);
    SocketAddress receive("192.168.0.1", 55151);

    for(;;) {
//        out_buffer = {rand(), rand()};
//        sock.recvfrom(&receive, &out_buffer, sizeof(out_buffer));
//        printf(out_buffer);
        if (0 > sock.sendto(receive, str4byte, sizeof(str4byte))) {
            printf("Error sending data\n");
        }
        printf("Update %d, %d, %d \n", str4byte[0], str4byte[1], str4byte[2]);
        ThisThread::sleep_for(2000);
    }
}


void ADC_thread(){
    struct ADE7912_Inst *ade = New_ADE7912(&hspi1);
    struct ADE7912_Phase_Settings a_phase;
    a_phase.CS_pin = PHASE_A_CS_Pin;
    a_phase.CS_port = PHASE_A_CS_GPIO_Port;
    ADE7912_PhaseInit(ade, &a_phase, PHASE_A);
    ADE7912_EnablePhase(ade, PHASE_A);
    //SCB_DisableDCache();
    
    uint32_t tickCount = osKernelSysTick();
  /* Infinite loop */
  for(;;)
  {     
        ADE7912_UpdateData(ade);

        bufFR  = (int32_t)(ADE7912_GetCurrent(ade, PHASE_A) * 1000);
        sprintf( (char *)str4byte, "%03d", (short)bufFR  );
        
//        TransmitUARTPackage(&huart3, str_cur+1, 12);
//        TransmitUARTPackage(&huart3, str4byte, 3);
//        TransmitUARTPackage(&huart3, str_vol+1, 12);
        
        bufFR  = (ADE7912_GetVoltage(ade, PHASE_A) * 1000);
        sprintf( (char *)str4byte, "%03d", (short)bufFR  );
        
//        TransmitUARTPackage(&huart3, str4byte, 3);
//        TransmitUARTPackage(&huart3, str_temp+1, 9);
        
        bufFR  = (ADE7912_GetTemp(ade, PHASE_A) * 1);
        sprintf( (char *)str4byte, "%03d", (short)bufFR  );
        
//        TransmitUARTPackage(&huart3, str4byte, 3);
//        TransmitUARTPackage(&huart3, str_space+1, 2);
        
        ThisThread::sleep_for(1000);
        
  }
    }

int main()
{
    MX_GPIO_Init();
    MX_DMA_Init();
    MX_SPI1_Init();
    
    thread.start(UDP_thread);

    thread.start(ADC_thread);

    //while (true) {
//        led1 = !led1;
//        ThisThread::sleep_for(500);
//    }
}
