//X300Y500Z1000\r\n - пример команды управления (3 угла в градусах)
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "AccelStepper.h"
#include <ctype.h>

const int q = 8;        // микрошаг
#define MSpeed  2000    // максимальная скорость

bool parseXYZ(char* m, float* A);
float readNum(char* m, int i);
void MotorsInit();
void Rx_interrupt();

PinName         stp[3] = {PB_15,PA_8,PA_9};
PinName         dir[3] = {PB_12,PB_13,PB_14};
AccelStepper    axis1(1, stp[0], dir[0]);
AccelStepper    axis2(1, stp[1], dir[1]);
AccelStepper    axis3(1, stp[2], dir[2]);
AccelStepper    Motors[3] = {axis1, axis2, axis3};

DigitalOut      myled(LED1);
DigitalOut      enb(PA_10);
Timer           t;
Timer           t_my;
Serial          pc(PB_10, PB_11);

bool flags[3] = {true, true, true};
////////////////////////////////////////////////////////////////////////////////////
int main()
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    t.start();
    t_my.start();
    pc.baud(9600);
    pc.attach(&Rx_interrupt, Serial::RxIrq);
    pc.printf("Hello\r\n");
    MotorsInit();
    while(1) {
        for (int i = 0; i < 3; i++) {
            Motors[i].runSpeedToPosition();
            if (Motors[i].distanceToGo() == 0 && flags[i] == false) {
                flags[i] = true;
                pc.printf("%d - finish in %d msec\r\n", i, t_my.read_ms());
            }
        }
        if (Motors[0].distanceToGo() == 0 && Motors[1].distanceToGo() == 0 && Motors[2].distanceToGo() == 0)
            myled = 1;
    }
}
///////////////////////////////////////////////////////////////////////////////////

void MotorsInit()
{
    enb = 0;
    myled = 0;
    for (int i = 0; i < 3; i++) {
        Motors[i].setMinPulseWidth (20);
        Motors[i].setMaxSpeed (MSpeed*2);
        Motors[i].setCurrentPosition(0);
    }
    myled = 1;
    pc.printf("Ready\r\n\r\n");
}


bool parseXYZ(char* m, float* A)
{
    for(int i = 0; i < 32; i++) {
        if (m[i] == '\n' || m[i] == '\r')
            break;
        /////////////////////////////////
        if (m[i] == 'X') {
            i++;
            A[0] = readNum(m, i);
        }
        ////////////////////////////////
        if (m[i] == 'Y') {
            i++;
            A[1] = readNum(m, i);
        }
        //////////////////////////////////
        if (m[i] == 'Z') {
            i++;
            A[2] = readNum(m, i);
        }
    }
    return true;
}

float readNum(char* m, int i)
{
    char buff[10] = "";
    int n = 0;
    while ((isdigit(m[i]) || m[i] == '.' || m[i] == '-') && n < 9) {
        buff[n] = m[i];
        i++;
        n++;
    }
    if (n == 0) {
        buff[n] = '0';
        n++;
    }
    buff[n] = '\0';
    return(atof(buff));
}


void constTime()
{
    float DeltaMax = 0;
    for (int i = 0; i < 3; i++) {
        if(abs(Motors[i].distanceToGo()) > DeltaMax)
            DeltaMax = abs(Motors[i].distanceToGo());
    }
    float k = MSpeed/DeltaMax;
    for (int i = 0; i < 3; i++) {
        Motors[i].setSpeed(k*abs(Motors[i].distanceToGo()));
        pc.printf("\r\nSpeed %d", int(k*abs(Motors[i].distanceToGo())));
    }
}

void Rx_interrupt()
{
    char message[32] = "";
    pc.scanf("%[^\n]s", message);
    strcat(message, "\n");
    pc.printf("\r\n%s", message);

    float angles[3] = {0, 0, 0};
    parseXYZ(message, angles);
    pc.printf("Angle: ");
    for (int i = 0; i < 3; i++) {
        pc.printf("%.2f ", angles[i]);
        Motors[i].move(int(angles[i]*q/1.8));
        flags[i] = false;
    }
    constTime();
    myled = 0;
    t_my.stop();
    t_my.reset();
    t_my.start();
    pc.printf("\r\nWait!\r\n");
    return;
}