#include "communication.h"
#include "cmsis_os.h"
#include <cstring>

//extern UART_HandleTypeDef huart3;
enum _BOOL_ uart3PkgTransmited = _FALSE_;
enum _BOOL_ uart3PkgReceived = _FALSE_;

extern SPI_HandleTypeDef hspi1;
ALIGN_32BYTES(volatile uint8_t spi1Buf[ALIGN32_SIZE(256)] __attribute__((section(".SRAM"))));
ALIGN_32BYTES(volatile uint8_t spi1AddrBuf __attribute__((section(".SRAM"))));
enum _BOOL_ spi1PkgTransmited = _FALSE_; 
enum _BOOL_ spi1PkgReceived = _FALSE_;
enum OP_TYPE spi1OpType = NONE;
//uint8_t *spi1Buf;
uint8_t spi1Len;

//void ReceiveUARTPackage(UART_HandleTypeDef *huart, uint8_t *buf, uint8_t len)
//{
//	TickType_t timeBegin = xTaskGetTickCount();
//	//SCB_InvalidateDCache();
//	HAL_StatusTypeDef err = HAL_UART_Receive_DMA(huart, buf, len);
//  while (!uart3PkgReceived  && xTaskGetTickCount() - timeBegin < COMMUNICATION_WAITTING) osDelay(COMMUNICATION_DELAY);
//  
//	uart3PkgReceived = _FALSE_;
//}



//void TransmitUARTPackage(UART_HandleTypeDef *huart, uint8_t *buf, uint8_t len)
//{
//	TickType_t timeBegin = xTaskGetTickCount();
//	//SCB_CleanDCache();
//	HAL_StatusTypeDef err = HAL_UART_Transmit_DMA(huart, buf, len);
//  while (!uart3PkgTransmited  && xTaskGetTickCount() - timeBegin < COMMUNICATION_WAITTING) osDelay(COMMUNICATION_DELAY);
//	
//  uart3PkgTransmited = _FALSE_;
//}
//
//
//
//void HAL_UART_TxCpltCallback(UART_HandleTypeDef *huart)
//{
//	if(huart == &huart3) {
//		uart3PkgTransmited = _TRUE_;
//  }
//}
//
//
//
//void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
//{
//  if(huart == &huart3){
//    uart3PkgReceived = _TRUE_;
//  }
//}



void WriteToRegisterBySPI(SPI_HandleTypeDef *hspi, uint8_t addr, uint8_t *buf, uint8_t len)
{
//	TickType_t timeBegin = xTaskGetTickCount();

	enum _BOOL_ *cpltCheck;
	if(hspi == &hspi1) {
		//spi1Buf = buf;
		spi1Len = len;
		spi1OpType = WRITE;
		cpltCheck = &spi1PkgTransmited;
  } 
	memcpy((void*)&spi1AddrBuf, (void*)&addr, 1);
	SCB_CleanDCache_by_Addr((uint32_t*)&spi1AddrBuf, ALIGN32_SIZE(1));
	HAL_SPI_Transmit_DMA(hspi, (uint8_t*)&spi1AddrBuf, 1);
	memcpy((void*)&spi1Buf, (void*)buf, 1);
//  while (!*cpltCheck  && xTaskGetTickCount() - timeBegin < COMMUNICATION_WAITTING) osDelay(COMMUNICATION_DELAY);
	*cpltCheck = _FALSE_;
}



void ReadFromRegisterBySPI(SPI_HandleTypeDef *hspi, uint8_t addr, uint8_t *buf, uint8_t len)
{
//	TickType_t timeBegin = xTaskGetTickCount();
	
	enum _BOOL_ *cpltCheck;
	if(hspi == &hspi1) {
		//spi1Buf = buf;
		spi1Len = len;
		spi1OpType = READ;
		cpltCheck = &spi1PkgReceived;
  } 
	
	memcpy((void*)&spi1AddrBuf, (void*)&addr, 1);
	SCB_CleanDCache_by_Addr((uint32_t*)&spi1AddrBuf, ALIGN32_SIZE(1));
	HAL_SPI_Transmit_DMA(hspi, (uint8_t*)&spi1AddrBuf, 1);
//  while (!*cpltCheck  && xTaskGetTickCount() - timeBegin < COMMUNICATION_WAITTING) osDelay(COMMUNICATION_DELAY);
	*cpltCheck = _FALSE_;
	memcpy((void*)buf, (void*)&spi1Buf, spi1Len);
}



void HAL_SPI_TxCpltCallback(SPI_HandleTypeDef *hspi)
{
	if(hspi == &hspi1) {
		switch (spi1OpType)
		{
			case WRITE:
				spi1OpType = CPLT;
				SCB_CleanDCache_by_Addr((uint32_t*)&spi1Buf, ALIGN32_SIZE(spi1Len));
				HAL_SPI_Transmit_DMA(hspi, (uint8_t*)spi1Buf, spi1Len);
			break;
			case READ:
				spi1OpType = CPLT;
				HAL_SPI_Receive_DMA(hspi, (uint8_t*)spi1Buf, spi1Len);
			break;
			case CPLT:
				spi1PkgTransmited = _TRUE_;
				spi1OpType = NONE;
			break;
			case NONE:
			break;
		}
  } 
}



void HAL_SPI_RxCpltCallback(SPI_HandleTypeDef *hspi)
{
	if(hspi == &hspi1) {
		SCB_InvalidateDCache_by_Addr((uint32_t*)&spi1Buf, ALIGN32_SIZE(spi1Len));
		spi1PkgReceived = _TRUE_;
		spi1OpType = NONE;
  } 
}

