/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "rtos.h"


#define ON (1)
#define OFF (0)

#define COLOR_RED (0b100)
#define COLOR_YELLOW (0b110)
#define COLOR_GREEN (0b010)
#define COLOR_BLUE (0b001)
#define COLOR_CYAN (0b011)
#define COLOR_MAZENTA (0b101)
#define COLOR_WHITE (0b111)
#define COLOR_BLACK (0b000)



/*** Network Information ***/
///myIpAddrこのモータドライバのIPアドレスを入力
#define myIpAddr "10.42.0.98" 
/// myPortこのプログラムで使用するポートを入力  
#define myPort 50000
/// NetMask このモータドライバ用のネットマスクを入力 
#define NetMask "255.255.255.0"
/// Gateway このモータドライバ用のゲートウェイを入力 
#define Gateway "10.42.0.1"

//Network
DigitalOut EthRecv_LED(LED1);
DigitalOut EthSend_LED(LED2);
DigitalOut Ethconnect_LED(LED4);

DigitalOut led_ctrl_5v(p8);
DigitalOut led_ctrl_12v(p9);
DigitalOut led_ctrl_24v(p10);
DigitalOut led_ctrl_main(p6);
DigitalOut led_motor_main_fuse(p5);
DigitalOut led_motor_12v_fuse(p7);
DigitalOut led_motor_main(p11);
DigitalOut led_motor_12v(p17);

DigitalIn relay_ctrl_main(p14, PullNone);
DigitalIn relay_motor_main(p12, PullNone);
DigitalIn relay_motor_12v(p13, PullNone);

AnalogIn ad_ctrl_main(p20);

Serial pc(USBTX, USBRX, 9600);

Mutex g_mtx;
typedef struct{
    char color,data;
}MONITOR;

MONITOR mon;



I2C i2c_master(p28, p27);
const char master_addr = 0x70;

/*CAN*/
CAN can_master(p30, p29);

void LedCheck(void);

//Ehternet Thread
void ethernet_thread(void){
    char in_buf[64];
    
    EthernetInterface eth;
    //eth.init();
    eth.init(myIpAddr,NetMask,Gateway);
    eth.connect();
    printf("\nServer IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(myPort);
    server.listen();
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection *client = new TCPSocketConnection;
        server.accept(*client);
        
        printf("Connection from: %s\n", client->get_address());
        
        while (client->is_connected()) {
            
            Ethconnect_LED = 1;
            int len = client->receive(in_buf, sizeof(in_buf));
            EthRecv_LED = !EthRecv_LED;
            // print received message to terminal
//            in_buf[len] = '\0';
            if(len > 0){
               // Timeout_timer.reset();
                in_buf[len] = '\0';
                //Get data
                EthRecv_LED = !EthRecv_LED;
                g_mtx.lock();
                memcpy(&mon.color, &in_buf[0], 1);
                memcpy(&mon.data, &in_buf[1], 1);
                //printf("Received message from Client :'%f'\n",pipe_pwmduty);
                g_mtx.unlock();
            }
        }
        printf("\nclient closed\n");
        Ethconnect_LED = 0;
        client->close();
        delete client;
    }
}


// main() runs in its own thread in the OS
int main()
{
    /* Start Thread */
    Thread thread_get(ethernet_thread);
    
    float voltage_ctrl_main = 0.0;
    char command;
    char address;
    char data[8];
    char can_data[2];
    led_ctrl_5v = OFF;
    led_ctrl_12v = OFF;
    led_ctrl_24v = OFF;
    led_ctrl_main = OFF;
    led_motor_main_fuse = OFF;
    led_motor_12v_fuse = OFF;
    led_motor_main = OFF;
    led_motor_12v = OFF;
    
    LedCheck();

    while (true) {
        /*address = 0b1001000;
        command = 0b10000011;        
        i2c_master.write(address, &command, 1, true);
        wait_us(300);
        i2c_master.read(address, &data[0], 1, true);
        
        command = 0b10010011;        
        i2c_master.write(address, &command, 1);
        wait_us(300);
        i2c_master.read(address, &data[1], 1, true);
        
        command = 0b10100011;        
        i2c_master.write(address, &command, 1);
        wait_us(300);
        i2c_master.read(address, &data[2], 1, true);
        
        command = 0b10110011;        
        i2c_master.write(address, &command, 1);
        wait_us(300);
        i2c_master.read(address, &data[3], 1, true);
        
        voltage_ctrl_main = (ad_ctrl_main.read() * 104.0 * 3.3 / 13.0);*/
        led_ctrl_main = relay_ctrl_main;
        led_motor_main_fuse = relay_motor_main;
        led_motor_main = relay_motor_main;
        led_motor_12v_fuse = relay_motor_12v;
        //printf("%04x\t%04x\t%04x\t%04x\t", data[0], data[1], data[2], data[3]);
        //printf("%f(v)\n", voltage_ctrl_main);
        
        if(ON == relay_motor_main)
        {
            can_data[0] = COLOR_YELLOW;
            can_data[1] = 0x10;
        }
        else
        {
            can_data[0] = COLOR_RED;
            can_data[1] = 0x10;
        }
        CANMessage msg(0x1852, can_data, sizeof(can_data), CANData, CANStandard);
        can_master.write(msg);
    }
}

void LedCheck(void)
{
    led_ctrl_5v = ON;
    wait(0.05f);
    led_ctrl_5v = OFF;
    
    led_ctrl_12v = ON;
    wait(0.05f);
    led_ctrl_12v = OFF;
    
    led_ctrl_24v = ON;
    wait(0.05f);
    led_ctrl_24v = OFF; 
    
    led_ctrl_main = ON;
    wait(0.05f);
    led_ctrl_main = OFF;
    
    led_motor_main_fuse = ON;
    wait(0.05f);
    led_motor_main_fuse = OFF;

    led_motor_12v_fuse = ON;
    wait(0.05f);
    led_motor_12v_fuse = OFF;
    
    led_motor_main = ON;
    wait(0.05f);
    led_motor_main = OFF;
    
    led_motor_12v = ON;
    wait(0.05f);
    led_motor_12v = OFF;
    
    led_ctrl_5v = ON;    
    led_ctrl_12v = ON;
    led_ctrl_24v = ON; 
    led_ctrl_main = ON;
    led_motor_main_fuse = ON;
    led_motor_12v_fuse = ON;
    led_motor_main = ON;
    led_motor_12v = ON;
    wait(0.2f);

    led_ctrl_12v = OFF;
    led_ctrl_5v = OFF;
    led_ctrl_24v = OFF;
    led_ctrl_main = OFF;
    led_motor_main_fuse = OFF;
    led_motor_12v_fuse = OFF;
    led_motor_main = OFF;
    led_motor_12v = OFF;

}    