#include "mbed.h"
#include "EthernetInterface.h"

#define MY_PORT 58083
#define T_1_SECOND 1

Serial  pc(USBTX, USBRX);           // default to 9600 8N1
#define log(...) { pc.printf(__VA_ARGS__); }

EthernetInterface interface;
UDPSocket socket;
SocketAddress addr;

int main(void) {
    nsapi_error_t st;
    const char *addr_char;
    char buffer[256];

    interface.connect();                                                        // link up and wait DHCP address
    addr_char = interface.get_ip_address();
    log("My IP Address: %s\n", addr_char);

    if (!addr.set_ip_address(addr_char)){
        log("ERROR: failed to set IP address %s\n", addr_char);
    }else{
        addr.set_port(MY_PORT);
    }

    if ((st = socket.open(&interface)) != NSAPI_ERROR_OK) {
        printf("Failed to open UDP Socket (status %d)\n", st);
    }

    if ((st = socket.bind((const SocketAddress)addr)) != NSAPI_ERROR_OK) {
        printf("Failed to bind UDP Socket to port %d (status %d)\n", MY_PORT, st);
    }

    while(1) {
        nsapi_size_or_error_t st = socket.recvfrom(&addr, (void *)buffer, (unsigned int)sizeof(buffer));
        if (st > 0) {
            buffer[st] = 0;
            log("received: %s\n", buffer);      // assuming text received
        }else{
            log("ERROR: socket.recvfrom : %d\n", st);        
        }

        wait(T_1_SECOND);
    }    
}