#include "PIDcontrol.h"


PidCon::PidCon(double p,double i,double d){
    
    reset(p,i,d);
    integ = 0;
    p_error = 0;
}

double PidCon::call(double error){
    
    double duty = 0;
    
    duty += error * gain[0];                // P制御
    
    integ += (error + p_error)/2;
    duty += integ * gain[1];                // I制御
    
    duty += (error - p_error) * gain[2];    // D制御
    
    return duty;
}

void PidCon::reset(double p,double i,double d){
    
    integ = 0;
    p_error = 0;
    gain[0] = p;
    gain[1] = i;
    gain[2] = d;
}

void PidCon::clear(){
    integ = 0;
}


