#ifndef INPUT_H
#define INPUT_H

#include "mbed.h"

/*****
    マイコンへのデジタル入力用のクラス
    スイッチ系センサ、ボタン入力に有効
    
                                          *****/

class ButtonIn{
public:
    enum ButtonState{Low = 0, High = 1, Rise = 2, Fall = -1};
    
    ButtonIn(PinName In);
    ButtonIn(PinName In, PinMode Pull);
    
    ButtonState state();    // ピンの状態を前回と比較しLow,High,Rise,Fallで返す
    bool read();            // ピンの状態をHigh,lowで返す
    void mode(PinMode pull);// プルアップ、プルダウンなどの設定
    
private:
    
    bool prevState;
    DigitalIn InputButton;
    
};


#endif