#include "Input.h"
    
ButtonIn::ButtonIn(PinName In) : InputButton(In){
    prevState = (bool)InputButton.read();
}

ButtonIn::ButtonIn(PinName In, PinMode Pull) : InputButton(In, Pull){
    prevState = (bool)InputButton.read();
}

ButtonIn::ButtonState ButtonIn::state(){
    
    bool crrState = InputButton.read();
    ButtonState value = Low;
    
    if(prevState && crrState)       value = High;
    else if(prevState && !crrState) value = Fall;
    else if(!prevState && crrState) value = Rise;
    
    prevState = crrState;
    
    return value;
}

bool ButtonIn::read(){
    return InputButton.read();
}

void ButtonIn::mode(PinMode pull){
    InputButton.mode(pull);
}

    