#include "Mecanum.h"

Mecanum::Mecanum() : MD(115200, PIN_MD, NC){
}


void Mecanum::command(double (&duty)[4]){
    MD.SpeedM1(ADR_MD1, (int)(duty[0]*CMD));
    MD.SpeedM2(ADR_MD1, (int)(duty[2]*CMD));
    MD.SpeedM1(ADR_MD2, (int)(duty[3]*CMD));
    MD.SpeedM2(ADR_MD2, (int)(duty[1]*CMD));
}

void Mecanum::move(double direction, double speed, double revolution){
    double duty[4];
    
    duty[0] = (cos(direction) - sin(direction))*speed - revolution;//右前
    duty[1] = (cos(direction) + sin(direction))*speed + revolution;//左前
    duty[2] = (cos(direction) + sin(direction))*speed - revolution;//右後
    duty[3] = (cos(direction) - sin(direction))*speed + revolution;//左後
    
    command(duty);
    
}

void Mecanum::rectang(double x,double y,double rotation){
    double duty[4];
    
    duty[0] = y - x - rotation;
    duty[1] = y + x + rotation;
    duty[2] = y + x - rotation;
    duty[3] = y - x + rotation;
    
    command(duty);
}