/** @file
 *四輪出力計算
 *motorのつき方、番号は\n
 *[1]↙︎....↖︎[0]\n
 *\n
 *[2]↘︎...↗ [3]\n
 *定数を変えれば容易に変更可能
 */
#ifndef SP18_ARM_MOVE4WHEEL_MOVE4WHEEL_H
#define SP18_ARM_MOVE4WHEEL_MOVE4WHEEL_H
/** 数学的なx,y,回転で出力を計算. GetMotorOut(int motor_num) を呼び出せば値が得られる
 * @param x_out 目標速度のx成分
 * @param y_out 目標速度のx成分
 * @param r_out 目標速度の回転成分
 */
void CalMotorOut(double x_out, double y_out, double r_out);
/**@param motor_num 車輪の番号(0,1,2,3)右上から反時計回りに定義
 * @return motorOut[motor_num]
 */
double GetMotorOut(int motor_num);
#endif