#include "mbed.h"
#include "ReceiverIR.h"

DigitalOut myled1(dp28); // MARY GREEN LED
DigitalOut myled2(dp14); // MARY BLUE LED
DigitalOut myled3(xp12);
ReceiverIR ir_rx(dp17);
//TX dp16 = USBTX RX dp15 = USBRX
Serial pc(USBTX, USBRX);

int receive(RemoteIR::Format *format, uint8_t *buf, int bufsiz, int timeout = 200)
{
    int cnt = 0;
    while (ir_rx.getState() != ReceiverIR::Received) {
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_rx.getData(format, buf, bufsiz * 8);
}

int main()
{
    pc.baud(9600);
    RemoteIR::Format format;
    uint8_t buf[512];
    int bufLength = 0;
    myled1 = myled2 = myled3 = 1;
    while(1) {
        myled1 = 0;
        bufLength = receive(&format, buf, sizeof(buf));
        if(bufLength < 0) continue;
        myled1 = 1;
        myled2 = 0;
        const int n = bufLength / 8 + (((bufLength % 8) != 0) ? 1 : 0);
        for (int i = 0; i < n; i++) {
            pc.printf("%02X", buf[i]);
        }
        pc.printf(" %d ", bufLength);
        switch (format) {
            case RemoteIR::UNKNOWN:
                pc.printf("UNKNOWN");
                myled2 = 1;
                myled3 = 0;
                break;
            case RemoteIR::NEC:
                pc.printf("NEC");
                break;
            case RemoteIR::NEC_REPEAT:
                pc.printf("NEC(R)");
                break;
            case RemoteIR::AEHA:
                pc.printf("AEHA");
                break;
            case RemoteIR::AEHA_REPEAT:
                pc.printf("AEHA(R)");
                break;
            case RemoteIR::SONY:
                pc.printf("SONY");
                break;
        }
        pc.printf(" OK\r\n");
        wait_ms(450);
        myled2 = 1;
        myled3 = 1;
        wait_ms(150);
    }
}
