#ifndef MAIN_H_INCLUDED
#define MAIN_H_INCLUDED

#include "mbed.h"
#include "rtos.h"

#include "EthernetInterface.h"
#include "NTPClient.h"

#include "MCSVM.hpp"
#include "SRNN.hpp"
#include "SensorModule.hpp"
#include "GraphicHandler.hpp"

#include "main_util.hpp"
#include "share.hpp"
#include "setup.hpp"

#include "./debug/debug.hpp" // 

// Pointer to Class instance (global)
extern SRNN            *srnn;
extern MCSVM           *mcsvm;
extern SensorModule    *sensor_module;
extern GraphicHandler  *graphic_handler;
// ネットワーク関係(global)
extern EthernetInterface    eth_if;
extern NTPClient            ntp_client;
// ファイルシステム(global)
extern LocalFileSystem      *local_fs;
// 系列データ(global)
extern float* new_seqence_data;        // 現在の(一番新しい)系列データ
extern float* new_predict_data;        // 現在の予測結果
extern int*   new_predict_weather;     // 現在の予測天気
extern float* new_predict_probability; // 現在の予測天気の確率（厳密には,確率ではない...）
extern float* srnn_sample_queue;       // SRNNのサンプルキュー

#endif /* MAIN_H_INCLUDED */