#include "main_util.hpp"

void update_srnn_sample(float* sample_queue, float* new_data)
{
    // 古いデータの消去, データのシフト
    for (int i = 0; i < DIM_SIGNAL * LEN_DATA_SEQUENCE; i++) {
        if ( i < DIM_SIGNAL * (LEN_DATA_SEQUENCE-1) ) 
            sample_queue[i] = sample_queue[i+DIM_SIGNAL];
    }
        
    // 末尾に新データを追加
    memcpy(&(sample_queue[DIM_SIGNAL * (LEN_DATA_SEQUENCE-1)]), new_data, sizeof(float) * DIM_SIGNAL);
}

// ファイルのオープンチェック(いや、fopenをラップしろよｻｰｾﾝ)
void check_file_open(FILE* file_p, const char* file_name)
{
    // static int open_count;
    // printf("[cnt:%d] %s : %p \r\n", open_count++, file_name, file_p);
    if ( file_p == NULL ) {
        fprintf( stderr, "Error : file %s open faild. \r\n", file_name );
        fflush( stderr );
        exit(1);
    }
}

// データ系列ファイルの行数をmaxlineまで切り詰める
void truncate_data_file(int maxline)
{
    FILE* dat_file_fp;
    const char tmp_file_name[] = "/local/TMP_DAT.CSV";
    int line, diff_line;
    char trunc_buf_str[BUF_SIZE];
    // 最初に現在の行数を数える
    dat_file_fp = fopen( SEQUENCE_DATA_NAME, "r");
    check_file_open( dat_file_fp, SEQUENCE_DATA_NAME);
    line = 0;
    while(fgets(trunc_buf_str, BUF_SIZE, dat_file_fp) != NULL) {
        line++;
    }
    fclose( dat_file_fp );

    // 切り詰め開始
    if ( line > maxline ) {
        FILE* tmp_fp;
        diff_line = (line - maxline);
        dat_file_fp = fopen(SEQUENCE_DATA_NAME, "r");
        // rewind( dat_file_fp );
        check_file_open( dat_file_fp, SEQUENCE_DATA_NAME );
        tmp_fp = fopen( tmp_file_name, "w");
        check_file_open( tmp_fp, tmp_file_name );
        line = 0;
        while(fgets(trunc_buf_str, BUF_SIZE, dat_file_fp) != NULL) {
            line++;
            if (line >= diff_line) break;
        }
        // diff_line以降をテンポラリにコピー

        while( fgets( trunc_buf_str, BUF_SIZE, dat_file_fp) != NULL) {
            fputs( trunc_buf_str, tmp_fp );
        }

        fclose( dat_file_fp );
        fclose( tmp_fp );

        // 更新
        tmp_fp = fopen( tmp_file_name, "r");
        check_file_open( tmp_fp, tmp_file_name );
        dat_file_fp = fopen(SEQUENCE_DATA_NAME, "w");
        check_file_open( dat_file_fp, SEQUENCE_DATA_NAME );
        // 一時ファイルからコピー
        while( fgets( trunc_buf_str, BUF_SIZE, tmp_fp) != NULL) {
            fputs( trunc_buf_str, dat_file_fp);
        }

        fclose( dat_file_fp );
        fclose( tmp_fp );

        // テンポラリの削除
        remove( tmp_file_name );
    }
}