#ifndef SHARE_H_INCLUDED
#define SHARE_H_INCLUDED

#include "mbed.h"

/* 共通のパラメタ類をマクロで定義 */

#define PREDICT_LENGTH        (4)               // 予測系列長
#define PREDICT_INTERVAL_TIME (1 * 60 * 60 * 1000)     // 予測間隔 : 1h
#define LEN_DATA_SEQUENCE     (50)              // 観測データの履歴長
#define NUM_WEATHERS          (4)               // 気候の種類
#define DIM_SIGNAL            (3)               // 信号の次元(=センサの数)
#define MCSVM_NUM_SAMPLES     (120)             // MCSVMのサンプル数
#define MAX_LOG_LENGTH        (1000)            // 観測データファイルの最大行数（これをこえるとやばい値）
#define SUITABLE_LOG_LENGTH   (500)             // 切り詰め後の最適なデータファイルの行数

#define BUF_SIZE              (100)             // fprintfの時などに使われる文字列バッファの長さ

/*
#ifdef DEFAULT_STACK_SIZE
#undef DEFAULT_STACK_SIZE 
#define DEFAULT_STACK_SIZE ((WORDS_STACK_SIZE*4) * 2.25)
#endif */ /* DEFAULT_STACK_SIZE */


#ifdef OS_MAINSTKSIZE
#undef OS_MAINSTKSIZE
#define OS_MAINSTKSIZE (DEFAULT_STACK_SIZE*8)
#endif /* OS_STKSIZE */

#define OS_STKCHECK     // スタックオーバーフローの監視

#ifdef BUFSIZ
#undef BUFSIZ
#define BUFSIZ (512)
#endif /* BUFSIZ */

#define SEQUENCE_DATA_NAME    "/local/SEQ_DAT.CSV"     // 系列データのファイル名
#define PREDICT_DATA_NAME     "/local/PRE_DAT.CSV"     // 予測データのファイル名

// 気候のインデックス
typedef enum {
    TEMPERATURE  = 0,   // 気温
    AIR_PRESSURE = 1,   // 気圧
    HUMIDITY     = 2,   // 湿度
} WEATHER_ID;

// 天候を表す列挙型
typedef enum {
    SHINY  = 0,  // 晴れ
    CLOUDY = 1,  // 曇
    RAINY  = 2,  // 雨
    SNOWY  = 3,  // 雪
} WEATHER_STATUS;

#endif /* SHARE_H_INCLUDED */