#include "debug.hpp"

void print_mat_func(float* mat, int row, int col)
{
    for (int i = 0; i < row; i++) {
        for (int j = 0; j < col; j++) {
            if (j == 0) {
                printf("|");
            }
            float val = MATRIX_AT(mat,col,i,j);
            if (val > 0) {
                printf(" ");
            }
            printf("%3.3f ",val);
            if (j == col-1) {
                printf("| \r\n");
            };
        }
    }
}

void print_vec_func(float* vec, int dim)
{
    for (int i = 0; i < dim; i++) {
        printf("%f ", vec[i]);
    }
    printf("\r\n");
}

void no_memory(void)
{
    error("panic: can't allocate to memory! \r\n");
    while(1);
}

extern "C" {

void HardFault_Handler(void)
{
    error("Hard Fault! \r\n");
    while(1);
}

void MemManage_Handler(void)
{
    error("MemManage Fault!\n");
    while(1);
}

void BusFault_Handler()
{
    error("BusFault Fault!\r\n");
    while(1);
}

void UsageFault_Handler()
{
    error("Usage Fault!\r\n");
    while(1);
}

}
