#ifndef DEBUG_H_INCLUDED
#define DEBUG_H_INCLUDED

#include "mbed.h"
#include <new> 

#include "../ml_util/ml_util.hpp"

// Debug Macros
#define DBG(...) printf("" __VA_ARGS__)
#define PRINT_INT(x) (printf(#x " : %d \r\n", x))
#define PRINT_FLT(x) (printf(#x " : %f \r\n", x))

#define PRINT_VEC(vec,dim) (printf("FILE[%s] LINE %d, %s: \r\n", __FILE__, __LINE__, (#vec)) \
                           (print_vec_func((vec),(dim)))
#define PRINT_MAT(mat,row,col) (printf("FILE[%s] LINE %d, %s: \r\n", __FILE__, __LINE__, (#mat)) \
                               (print_vec_func((vec),(row),(col)))
#define PRINT_P(name)      (printf("%s : %p \r\n", (#name), (name)))

// Debug Modules

void print_vec_func(float* vec, int dim);

void print_mat_func(float* mat, int row, int col);

void write_log(char* name, ...);

void no_memory(void);               // error handler for memory allocate failing

/*
extern void HardFault_Handler(void);
extern void MemManage_Handler(void);
extern void BusFault_Handler(void);
extern void UsageFault_Handler(void);
*/

#endif /* DEBUG_H_INCLUDED */

