#ifndef SENSORMODULE_H_INCLUDED
#define SENSORMODULE_H_INCLUDED

#include "mbed.h"
#include "DHT11.h"
#include "LM75B.h"
#include "MPL115A2.h"

class SensorModule
{
private:
    // こいつらがキューになってると便利そう（小並感）
    float  new_temperture;      // 最後に記録した温度
    float  new_humidity;        // 最後に記録した湿度
    float  new_pressure;        // 最後に記録した気圧
    
    AnalogIn* temperture_sensor;// 温度センサーLM75B
    DHT11*    humidity_sensor;  // 湿度センサーDHT11(精度が論値なので,変えるかも)
    I2C*      pressure_i2c;     // 気圧センサーMPL115A2用のI2C
    MPL115A2* pressure_sensor;  // 気圧センサーMPL115A2

public:
    int   n_sample;             // 1度のサンプリングでの読み出し回数
    
    public:
    SensorModule(int);           // 読み出し回数を引数にとる.
    ~SensorModule(void);
    
    // 各種観測値のゲッター
    inline float get_temperture(void) { return new_temperture; }
    inline float get_humidity(void) { return new_humidity; }
    inline float get_pressure(void) { return new_pressure; }
    
    // 全てのセンサーから値を読み出し, 最新値に更新する
    void read_all_sensor(void);
    
};

#endif /* SENSORMODULE_H_INCLUDED */