#ifndef GRAPHICHANDLER_H_INCLUDED
#define GRAPHICHANDLER_H_INCLUDED

#include "mbed.h"
#include "C12832_lcd.h"
#include "Arial_9.h"
#include "Small_7.h"
#include "Small_6.h"
#include "share.hpp"

// 表示モード
typedef enum {
    LEARNING,       // 観測/学習中
    DISPLAYING,     // 表示中
} DISPLAY_STATUS;

class GraphicHandler
{
private:
    time_t      now_time;           // 独自に保持する時間構造体
    time_t      last_learned_time;  // 最後に学習した時刻
    int         data_dimension;     // 観測/予測データ次元
    float*      now_data;           // 現在の観測データ
    int         predict_length;     // 予測系列長
    int         seq_time_interval;  // 予測時間の間隔:単位は分
    int         current_display_no; // 現在の画面No
    int         current_image_no;   // 現在のビットマップNo
    float*      predict_data;       // 予測データ
    float*      predict_probability;// 予測天候確率
    int*        predict_weather;    // 予測天候の列
    // Ticker      time_ticker;        // 時間更新用のティッカー               -> 廃止. main側で更新
    // Ticker      image_ticker;       // ビットマップアニメーションのティッカー ->  廃止.
    InterruptIn* joy_left;          // ジョイスティックの操作割り込み入力
    InterruptIn* joy_right;
    C12832_LCD  lcd;                // ステータス表示ターゲットのLCD
    
public:
    // やること: now_timeの大麻割り込み設定, predic_lenの設定, 配列アロケート
    GraphicHandler(int,  // 観測データの次元（現在, 温度/気圧/湿度で3）
                   int,  // 時間間隔
                   int,  // 予測系列の長さ.   
                   time_t); // 初期設定時間
                   
    ~GraphicHandler(void);
                                   
    // 予測データと天候のセット.
    void set_predict_data(float*, // 予測データ 
                          int*,   // 予測天候
                          float*);// 予測確率  
                          
    // 現在の観測データのセット
    void set_now_data(float*);    // 観測データ
    
    // 描画更新
    void update_draw(void);
    
    // 天候ビットマップの描画
    void draw_weather_bitmap_at(int,   // 天候
                                int,   // 画像No(アニメーション表示のため)
                                int,   // x座標
                                int);  // y座標
    // 時間の描画
    void draw_time_at(unsigned char*,   // フォント識別
                      int,              // 現在時刻からの経過時間（予測時刻を表現）:単位は分
                      int,              // x座標 
                      int);             // y座標
    // 観測/予測データの描画
    void draw_data_at(float,            // データ数値
                      const char*,      // 単位を表す文字列
                      unsigned char*,   // フォント識別
                      int,              // x座標
                      int);             // y座標
    // テキストの描画. フォント/サイズもラップ
    void draw_text_at(const char*,      // テキスト
                      unsigned char*,   // フォント識別文字列(Arial_9, Small_6, Small_7)
                      int,              // x座標
                      int);             // y座標
    // ログ出力.
    void draw_log(const char*);         // テキスト
    // 予測確率の描画.
    void draw_percentage_at(float,          // 確率値[0,1]
                            unsigned char*, // フォント
                            int,            // x座標
                            int);           // y座標
    
    // ジョイスティックの入力割り込みハンドラ
    void joyleft_isr(void);
    void joyright_isr(void);
    
    // 時間更新. 定期的に呼び出す（一分毎でええやん！）
    void update_time(void);
    // 最終学習時刻の更新
    void update_last_learned_time(void);
    // ビットマップ画像の更新.
    void update_image(void);
};

#endif /* GRAPHICHANDLER_H_INCLUDED */