#ifndef MENU_H
#define MENU_H

char* main_menu = "\n \
**********************************************\n \
Welcome to Freescale ADAM Adapter Menu\n\n \
Press 1 to set phase shift for RF out1\n \  
Press 2 to set attenuation for RF out1\n \
Press 3 to set phase shift for RF out2\n \
Press 4 to set attenuation for RF out2\n \
Press 5 to set SPI bits directly\n \
Press 6 to see the current parameters\n \
Press 7 to send the parameters to ADAM\n \
Press 8 for help\n\n \
**********************************************\n\n\n";

char* cmd1 = "Input phase shift(in degree) for RF out1(range 0 to -49, step -7)\n";
char* cmd2 = "Input attenuation(in dB) for RF out1(range 0 to 7.5, step 0.5)\n";
char* cmd3 = "Input phase shift(in degree) for RF out2(range 0 to -49, step -7)\n";
char* cmd4 = "Input attenuation(in dB) for RF out2(range 0 to 7.5, step 0.5)\n";
char* cmd5 = "Input the 16 bits SPI stream(b7-b0 a7-a0) in hex(for example 12ab)\n";

char* msg_strlong = "\nInput string too long, press any key to return to main menu and you may press 8 to see help\n";
char* msg_err = "\nInvalid input, press any key to return to main menu and you may press 8 to see help\n";
char* msg_rounded = "\nInput value accepted \nNote: Input value rounded to ";
char* msg_empty = "\nInput empty, skip\n";
char* msg_strshort = "\nInput string too short, press any key to return to main menu and you may press 8 to see help\n";
char* msg_ok = "\nInput value accepted\n";
char* msg_ret = "\nPress any key to return\n";

char* msg_help = "\n\n \
1. Attenuation value(in dB) ranges from 0 to 7.5 with 0.5 increment.\n \
So acceptable value is 0, 0.5, 2.0, 4.5, etc, and input value between these values is rounded.\n\n \
2. Phase shift value(in degree) ranges from 0 to -49 with -7 increment.\n \
So acceptable value is 0, -7, -35, etc, and input value between these values is rounded.\n\n \
3. You can set the SPI bit stream directly by choosing 5 in main menu.\n \
The SPI bit stream is a 16 bit hex value, MSB first. The stream format is (b7-b0 a7-a0).\n \
Note that the reserved bit b3 and a3 is ignored so input ffff is the same as f7f7, for example. \n\n \
4. Remember to press 7 to once you decide to update ADAM evaluation board. Update will not be made unless you press 7.\n\n \
Firmware author: Yuhang Zhu\n \
Firmware version: v1.0\n \
If you have any question, contact author at b46609@freescale.com\n \
";


char* bit_index = "b7 b6 b5 b4 b3 b2 b1 b0    a7 a6 a5 a4 a3 a2 a1 a0\n";

                    
                      


#endif