/* Author: Edoardo De Marchi 
 * Name: Test Code for MMA7660FC
 */
#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "TSISensor.h"
#include <ctype.h>
#define MMA8451_I2C_ADDRESS (0x1d<<1)                  // I2C SLAVE ADDR MMA7660FC
#define buffer_size 255
Ticker lightsensor_tick;
Ticker Mag_x_tick;
Ticker Mag_y_tick;
Ticker Mag_z_tick;
Ticker Acc_x_tick;
Ticker Acc_y_tick;
Ticker Acc_z_tick;
Ticker Touch_tick;
float rate=1.0;
int buff = 0;
char buffer[32];
int sample_light = 1;
MAG3110 mag(PTE25,PTE24);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);      //sda, scl, Addr
TSISensor touch;
Serial pc(USBTX, USBRX);
AnalogIn lightsensor(PTE22);
volatile int tx_in=0;
volatile int tx_out=0;
char tx_line[80];
char tx_buffer[buffer_size];
unsigned char c = ' ';
float x=0, y=0, z=0, l=0, t=0;
int mx, my, mz;
void Tx_interrupt();
void send_line();
void sendInt(int x)
{
    char *p = (char *)&x;
    pc.putc(*p);
    pc.putc(*(p+1));
    pc.putc(*(p+2));
    pc.putc(*(p+3));
}
void sendFloat(float x)
{
    char *p = (char *)&x;
    pc.putc(*p);
    pc.putc(*(p+1));
    pc.putc(*(p+2));
    pc.putc(*(p+3));
}
void send_line()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    //_disable_irq(pc.RxIrq);
    empty = (tx_in == tx_out);
    while ((i==0) || (tx_line[i-1] != '\n')) 
    {
// Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) 
        {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) 
            {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = tx_line[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (pc.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
// Send first character to start tx interrupts, if stopped
        pc.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}
void light_tick()
{
    if(c == '1' || c=='9')
    {
        l = lightsensor.read();
        pc.putc('1');
        sendFloat(l);
    }
        
    return;
}
void mx_tick()
{
    if(c=='2' || c=='9')
    {
        mag.getValues(&mx, &my, &mz);
        pc.putc('2');
        sendInt(mx);
    }
    return;
}
void my_tick()
{
     if(c=='3' || c=='9')
    {
        mag.getValues(&mx, &my, &mz);
        pc.putc('3');
        sendInt(mz);
    }
    return;
}
void mz_tick()
{
     if(c=='4' || c=='9')
    {
        mag.getValues(&mx, &my, &mz);
        pc.putc('4');
        sendInt(my);
    }    
    return;
}
void ax_tick()
{
    if(c=='6' || c=='9')
    {
        x = acc.getAccX();
        pc.putc('6');
        sendFloat(x);
    }
    return;
}
void ay_tick()
{
    if(c=='7' || c=='9')
    {
        y = acc.getAccY();
        pc.putc('7');
        sendFloat(y);
    }
    return;
}
void az_tick()
{   
    if(c=='8' || c=='9')
    {
        z = acc.getAccZ();
        pc.putc('8');
        sendFloat(z);
    }
    return;
}
void touch_tick()
{
    if(c=='5'||c=='9')
    {
        t = touch.readPercentage();
        pc.putc('5');
        sendFloat(t);
    }    
    return;
}
void receive_handler()
{
    memset(buffer, 0 , sizeof(buffer));
    buff=0;
    while (1)
    {
        buffer[buff] = pc.getc();
        if (buffer[buff] == '\n' || buffer[buff] == '\r')
        {
        buff++;
       
        break;
        }
        buff++;
    }
     c = buffer[0];
     int i = 1;
     rate = 0;
     while ((buffer[i]>='0') && (buffer[i]<='9'))
     {
         rate = rate*10 + buffer[i]-'0';
         i++;
         if (buffer[i] == '\n' || buffer[i] == '\r')
         break;
     }
    //pc.putc(buffer[1]);
    //lightsensor_tick.detach();
    switch (c)
    {
      case '0':
                 lightsensor_tick.detach();
                 Mag_x_tick.detach();
                 Mag_y_tick.detach();
                 Mag_z_tick.detach();
                 Touch_tick.detach();
                 Acc_x_tick.detach();
                 Acc_y_tick.detach();
                 Acc_z_tick.detach();
                 break;
      case '1':  lightsensor_tick.attach(&light_tick,1/rate);
                break;
      case '2':  Mag_x_tick.attach(&mx_tick,1/rate);
                break;
      case '3':  
                 Mag_y_tick.attach(&my_tick,1/rate);
                break;
      case '4':
                 Mag_z_tick.attach(&mz_tick,1/rate);
                 break;
      case '5':  Touch_tick.attach(&touch_tick,1/rate);
                 break;
      case '6':
                 Acc_x_tick.attach(&ax_tick,1/rate);
                 break;
      case '7':
                 Acc_y_tick.attach(&ay_tick,1/rate);
                 break;
      case '8': 
                 Acc_z_tick.attach(&az_tick,1/rate);
                 break;
      case '9':
                 lightsensor_tick.attach(&light_tick,1/rate);
                 Mag_x_tick.attach(&mx_tick,rate);
                 Mag_y_tick.attach(&my_tick,1/rate);
                 Mag_z_tick.attach(&mz_tick,1/rate);
                 Acc_x_tick.attach(&ax_tick,1/rate);
                 Acc_y_tick.attach(&ay_tick,1/rate);
                 Acc_z_tick.attach(&az_tick,1/rate);
                 Touch_tick.attach(&touch_tick,1/rate);
                 break;
    }
    return;
}
int main() 
{
    pc.baud(9600);                                                // Initialization
//    pc.attach(&keyInterrupt, pc.RxIrq);                           // Key In Interrupt 
    pc.attach(&receive_handler,pc.RxIrq);
        //lightsensor_tick.attach(&light_tick,3);
        
        
        
    while(1)
    {   
    }
    
}
void Tx_interrupt() {
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((pc.writeable()) && (tx_in != tx_out)) {
        pc.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    return;
}
