#include "mbed.h"
#include "TextLCD.h"
#include "EthernetInterface.h"
#include "fiap.h"

EthernetInterface eth;

TextLCD lcd(p24, p26, p27, p28, p29, p30);
DigitalOut led(LED1);
char timezone[] = "+09:00";  // JST
FIAP fiap("http://www.futaba-kikaku.jp/services/jyukyu.php");
char ademand[7];
struct fiap_element element[]= {
    {"http://futaba-kikaku.jp/epco/tepco/demand",ademand,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
};


void tick(void )
{
    float demand;
    led=!led;
    fiap.fetch_last_data(element,1);
    demand=atof(element[0].value);
    lcd.locate(0,1);
    lcd.printf("%02d:%02d:%02d %5.0f",element[0].hour,element[0].minute,element[0].second,demand);
   }

int main()
{
    eth.init(); //Use DHCP
    eth.connect();
    lcd.cls();
    lcd.locate(0,0);
    //lcd.printf("%s", eth.getIPAddress());
    lcd.printf("tepco demand");
    fiap.debug_mode=true;
    while(true) {
        tick();
        wait(60);
    }
}
