#include "mbed.h"
#include "TextLCD.h"
#include "EthernetInterface.h"
#include "fiap.h"

EthernetInterface eth;

TextLCD lcd(p24, p26, p27, p28, p29, p30);
DigitalOut led(LED1);
char timezone[] = "+09:00";  // JST
FIAP fiap("http://192.168.1.3/axis2/services/FIAPStorage");
char atemp[10];
struct fiap_element element[]= {
    {"http://csse-tech.jp/temp_tauchi",atemp,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
};


void tick(void )
{
    float temp;
    led=!led;
    fiap.fetch_last_data(element,1);
    temp=atof(element[0].value);
    lcd.locate(0,1);
    lcd.printf("%2d:%2d:%2d %4.1fDeg",element[0].hour,element[0].minute,element[0].second,temp);
   }

int main()
{
    eth.init(); //Use DHCP
    eth.connect();
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s", eth.getIPAddress());
    //fiap.debug_mode=true;
    while(true) {
        tick();
        wait(2);
    }
}
