#include "mbed.h"
#include "TextLCD.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "fiap.h"

#define NTPServer "ntp.nict.jp"

EthernetInterface eth;
NTPClient ntp;
Ticker timer1;
time_t ctTime;

TextLCD lcd(p24, p26, p27, p28, p29, p30);
AnalogIn ain(p15);
DigitalOut led(LED1);
char timezone[] = "+09:00";  // JST
char atemp[6];
FIAP fiap("http://192.168.1.3/axis2/services/FIAPStorage");
struct fiap_element element[]= {
    {"http://csse-tech.jp/temp_tauchi",atemp,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
};


void tick(void )
{
    float temp;
    char buffer[9];
    led=!led;
    temp=ain*3.3*100.0;
    ctTime = time(NULL);
    strftime(buffer,9,"%X",localtime(&ctTime));
    lcd.locate(0,1);
    lcd.printf("%s %4.1fDeg",buffer,temp);
// Save to FIAPStorage
    sprintf(atemp,"%4.1f",temp);
    struct tm t = *localtime(&ctTime);
    element[0].value=atemp;
    element[0].year=t.tm_year+1900;
    element[0].month=t.tm_mon+1;
    element[0].day=t.tm_mday;
    element[0].hour=t.tm_hour;
    element[0].minute=t.tm_min;
    element[0].second=t.tm_sec;
    fiap.post(element,1);
}

int main()
{
//Ethernet Initialize
    eth.init(); //Use DHCP
    eth.connect();
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s", eth.getIPAddress());
    printf("Trying to update time...\r\n");
    if (ntp.setTime(NTPServer) == 0) {
        printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        ctTime+=32400;
        set_time(ctTime);
        ctTime = time(NULL);
        printf("Time is set to (JST): %s\r\n", ctime(&ctTime));
        printf("finish \n");
    } else {
        lcd.locate(0,1);
        lcd.printf("Error");
        return -1;
    }
    //fiap.debug_mode=true;
    //eth.disconnect();
    while(true) {
        tick();
        wait(2);
    }
}
