#include "mbed.h"
#include "rtos.h"
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Queue<uint32_t, 5> queue;

DigitalIn jjy(p20);

Serial pc(USBTX, USBRX);

char rcv[100];
char timing=0;
void jjy_rcv(void const *n)
{
    static int count=0;
    if(jjy) {
        rcv[count]=1;
    } else {
        rcv[count]=0;
    }
    led1=rcv[count];
    if(count==timing) {
        queue.put((uint32_t*)1);
        //printf("thread out timing=%d \n\r",timing);
    }
    //  pc.printf("%d %d \n\r",count,rcv[count]);
    if(count==99)
        count=0;
    else
        count++;
}

int main()
{
    unsigned char state=0;
    unsigned char sig,old_sig;
    unsigned char count1=0;
    bool flag1,flag2;
    char m,h;
    char mm[3];
    int i,j;
    char sum_rcv[100];
    pc.baud(115200);
    flag1=true;
    flag2=true;
    old_sig=9;
    m=0;h=0;
    for(i=0; i<100; i++)sum_rcv[i]=0;
    RtosTimer jjy_rcv_timer(jjy_rcv, osTimerPeriodic,(void *)0);
    jjy_rcv_timer.start(10); //10mS
    printf("*********************stage1 (Sync)*********************\n\r");
    while (flag1) {
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
            printf("%d thread out timing=%d \n\r",count1,timing);
            for(i=0; i<100; i++)sum_rcv[i]+=rcv[i];
            if(count1==20) {
                for(i=1; i<100; i++) {
                    if(sum_rcv[i]>18) {
                        timing=i-1;
                        flag1=false;
                        break;
                    }
                }
                if(flag1==true) {
                    count1=0;
                    for(i=0; i<100; i++)sum_rcv[i]=0;
                }
            } else {
                count1++;
            }
        }
    }
//for(i=0; i<100; i++)printf("%d %d \n\r",i,sum_rcv[i]);
    printf("*********************stage1 end*****************************\n\r");
    printf("timing= %d\n\r",timing);
    osEvent evt = queue.get();
    printf("*********************stage2 time setting********************\n\r");
    state=0;
    while (flag2) {
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
            j=0;
            for(i=0; i<100; i++)j+=rcv[i];
            if(j<30) {
                sig=2;
                strcpy(mm,"M");
                led2=1;
                led3=0;
                led4=0;
            } else {
                if(j<65) {
                    sig=1;
                    strcpy(mm,"1");
                    led2=0;
                    led3=1;
                    led4=0;
                } else {
                    if(j<90) {
                        sig=0;
                        strcpy(mm,"0");
                        led2=0;
                        led3=0;
                        led4=1;
                    } else {
                        sig=9;
                        strcpy(mm,"?");
                        led2=1;
                        led3=1;
                        led4=1;
                    }
                }
            }
            printf("Signal %d %s\n\r",j,mm);

            switch(state) {
                case 0:
                    if((old_sig==2)&&(sig==2)) {
                        state=1;
                    }
                    break;
                case 1:
                    if((sig==0)||(sig==1)) {
                        m=40*sig;
                        state=2;
                    } else {
                        state=0;
                    }
                    break;
                case 2:
                    if((sig==0)||(sig==1)) {
                        m+=20*sig;
                        state=3;
                    } else {
                        state=0;
                    }
                    break;
                case 3:
                    if((sig==0)||(sig==1)) {
                        m+=10*sig;
                        state=4;
                    } else {
                        state=0;
                    }
                    break;
                case 4:
                    if((sig==0)||(sig==1)) {
                        state=5;
                    } else {
                        state=0;
                    }
                    break;
                case 5:
                    if((sig==0)||(sig==1)) {
                        m+=8*sig;
                        state=6;
                    } else {
                        state=0;
                    }
                    break;
                case 6:
                    if((sig==0)||(sig==1)) {
                        m+=4*sig;
                        state=7;
                    } else {
                        state=0;
                    }
                    break;
                case 7:
                    if((sig==0)||(sig==1)) {
                        m+=2*sig;
                        state=8;
                    } else {
                        state=0;
                    }
                    break;
                case 8:
                    if((sig==0)||(sig==1)) {
                        m+=sig;
                        state=9;
                    } else {
                        state=0;
                    }
                    break;
                case 9:
                    state=10;
                    break;
                case 10:
                    if((sig==0)||(sig==1)) {
                        state=11;
                    } else {
                        state=0;
                    }
                    break;
                case 11:
                    if((sig==0)||(sig==1)) {
                        state=12;
                    } else {
                        state=0;
                    }
                    break;
                case 12:
                    if((sig==0)||(sig==1)) {
                        h=20*sig;
                        state=13;
                    } else {
                        state=0;
                    }
                    break;
                case 13:
                    if((sig==0)||(sig==1)) {
                        h+=10*sig;
                        state=14;
                    } else {
                        state=0;
                    }
                    break;
                case 14:
                    if((sig==0)||(sig==1)) {
                        state=15;
                    } else {
                        state=0;
                    }
                    break;
                case 15:
                    if((sig==0)||(sig==1)) {
                        h+=8*sig;
                        state=16;
                    } else {
                        state=0;
                    }
                    break;
                case 16:
                    if((sig==0)||(sig==1)) {
                        h+=4*sig;
                        state=17;
                    } else {
                        state=0;
                    }
                    break;
                case 17:
                    if((sig==0)||(sig==1)) {
                        h+=2*sig;
                        state=18;
                    } else {
                        state=0;
                    }
                    break;
                case 18:
                    if((sig==0)||(sig==1)) {
                        h+=sig;
                        state=19;
                    } else {
                        state=0;
                    }
                    break;
                case 19:
                    flag2=0;
                    state=0;
                    break;
            }
            printf("%d   %02d:%02d \n\r",state,h,m);
            old_sig=sig;
        }
    }
    jjy_rcv_timer.stop();
    printf("Now = %02d:%02d:20 \n\r",h,m);
}
